/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.generation;

import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.misc.PrettyPrinter;
import net.emustudio.edigen.nodes.Decoder;
import net.emustudio.edigen.nodes.Mask;
import net.emustudio.edigen.nodes.Pattern;
import net.emustudio.edigen.nodes.Rule;
import net.emustudio.edigen.nodes.Subrule;
import net.emustudio.edigen.nodes.Variant;

public class GenerateMethodsVisitor
extends Visitor {
    private final PrettyPrinter printer;
    private final Queue<Rule> rootRulesLeft = new LinkedList<Rule>();
    private Rule ruleToTry;
    private Rule currentRule;
    private boolean isDefaultCase = false;
    private boolean unitWasRead;
    private int unitLastStart;
    private int unitLastLength;

    public GenerateMethodsVisitor(Writer output) {
        this.printer = new PrettyPrinter(output);
    }

    @Override
    public void visit(Decoder decoder) throws SemanticException {
        ArrayList<Rule> rootRulesToTry = new ArrayList<Rule>(decoder.getRootRules());
        rootRulesToTry.remove(0);
        this.rootRulesLeft.addAll(rootRulesToTry);
        decoder.acceptChildren(this);
    }

    @Override
    public void visit(Rule rule) throws SemanticException {
        this.currentRule = rule;
        this.isDefaultCase = false;
        this.unitWasRead = false;
        this.ruleToTry = rule.isRoot() && !this.rootRulesLeft.isEmpty() ? this.rootRulesLeft.poll() : null;
        String secondParameter = rule.hasOnlyOneName() ? "" : ", int rule";
        this.put("private void " + this.currentRule.getMethodName() + "(int start" + secondParameter + ") throws InvalidInstructionException {");
        rule.acceptChildren(this);
        this.put("}", true);
    }

    @Override
    public void visit(Mask mask) throws SemanticException {
        boolean alreadyRead;
        boolean isZero = mask.getBits().containsOnly(false);
        int maskStart = mask.getStart();
        int maskLength = mask.getBits().getLength();
        boolean bl = alreadyRead = this.unitWasRead && this.unitLastStart == maskStart && this.unitLastLength == maskLength;
        if (!(this.isDefaultCase || isZero || alreadyRead)) {
            if (maskLength > 32) {
                throw new SemanticException(String.format("Mask length %d is over maximum %d bits", maskLength, 32), mask);
            }
            if (maskStart == 0) {
                this.put(String.format("unit = readBits(start, %d);", maskLength), true);
            } else {
                this.put(String.format("unit = readBits(start + %d, %d);", maskStart, maskLength), true);
            }
            this.unitWasRead = true;
            this.unitLastStart = maskStart;
            this.unitLastLength = maskLength;
        }
        this.isDefaultCase = false;
        if (!isZero) {
            this.put("switch (unit & 0x" + mask.getBits().toHexadecimal() + ") {");
        }
        mask.acceptChildren(this);
        if (!isZero && !this.isDefaultCase) {
            this.put("default:");
            if (this.ruleToTry != null) {
                if (this.ruleToTry.hasOnlyOneName()) {
                    this.put(this.ruleToTry.getMethodName() + "(0);");
                } else {
                    this.put(this.ruleToTry.getMethodName() + "(0, " + this.ruleToTry.getFieldName() + ");");
                }
            } else {
                this.put("throw new InvalidInstructionException();");
            }
        }
        if (!isZero) {
            this.put("}");
        }
    }

    @Override
    public void visit(Pattern pattern) throws SemanticException {
        boolean thisIsDefaultCase;
        boolean bl = thisIsDefaultCase = pattern.getBits().getLength() == 0;
        if (!thisIsDefaultCase) {
            this.put("case 0x" + pattern.getBits().toHexadecimal() + ":");
        } else {
            this.put("default:");
        }
        pattern.acceptChildren(this);
        if (!thisIsDefaultCase) {
            this.put("break;");
        }
        this.isDefaultCase = thisIsDefaultCase;
    }

    @Override
    public void visit(Variant variant) throws SemanticException {
        if (variant.returns()) {
            String field = "rule";
            if (this.currentRule.hasOnlyOneName()) {
                field = this.currentRule.getFieldName(this.currentRule.getNames().get(0));
            }
            if (variant.getReturnString() != null) {
                String value = "\"" + variant.getReturnString() + "\", " + variant.getFieldName();
                this.put(String.format("instruction.add(%s, %s);", field, value));
            } else {
                int start = variant.getReturnSubrule().getStart();
                int length = variant.getReturnSubrule().getLength();
                if (length > 32) {
                    throw new SemanticException(String.format("Sub-rule %s length %d is over maximum %d bits", variant.getReturnSubrule().getName(), length, 32), variant);
                }
                String value = start == 0 ? String.format("readBits(start, %d)", length) : String.format("readBits(start + %d, %d)", start, length);
                this.put(String.format("instruction.add(%s, %s, %d);", field, value, length));
            }
        }
        variant.acceptChildren(this);
    }

    @Override
    public void visit(Subrule subrule) {
        Object fieldToWrite = "";
        if (!subrule.getRule().hasOnlyOneName()) {
            fieldToWrite = ", " + subrule.getFieldName();
        }
        String methodName = subrule.getRule().getMethodName();
        int start = subrule.getStart();
        if (start == 0) {
            this.put(methodName + "(start" + (String)fieldToWrite + ");");
        } else {
            this.put(methodName + "(start + " + subrule.getStart() + (String)fieldToWrite + ");");
        }
    }

    private void put(String lineOfCode, boolean newBlock) {
        this.printer.writeLine(lineOfCode);
        if (newBlock) {
            this.printer.writeLine("");
        }
    }

    private void put(String lineOfCode) {
        this.put(lineOfCode, false);
    }
}

