/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.generation;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.stream.Collectors;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.nodes.Disassembler;
import net.emustudio.edigen.nodes.Format;
import net.emustudio.edigen.nodes.TreeNode;
import net.emustudio.edigen.nodes.Value;

public class GenerateParametersVisitor
extends Visitor {
    private final PrintWriter writer;

    public GenerateParametersVisitor(Writer writer) {
        this.writer = new PrintWriter(writer, true);
    }

    @Override
    public void visit(Disassembler disassembler) throws SemanticException {
        Iterator<TreeNode> formats = disassembler.getChildren().iterator();
        while (formats.hasNext()) {
            formats.next().accept(this);
            if (!formats.hasNext()) continue;
            this.writer.println(",");
        }
    }

    @Override
    public void visit(Format format) throws SemanticException {
        this.writer.print("{");
        Iterator<TreeNode> values = format.getChildren().iterator();
        while (values.hasNext()) {
            values.next().accept(this);
            if (!values.hasNext()) continue;
            this.writer.println(",");
            this.writer.print(" ");
        }
        this.writer.print("}");
    }

    @Override
    public void visit(Value value) throws SemanticException {
        String strategies = value.getStrategies().stream().map(s -> "Strategy::" + s).collect(Collectors.joining(","));
        this.writer.print("new Parameter(" + value.getFieldName() + ", List.of(" + strategies + "))");
    }
}

