/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.misc;

import java.util.BitSet;
import java.util.regex.Pattern;

public class BitSequence {
    private static final int NIBBLE_LENGTH = 4;
    private static final Pattern BIN_NUMBER = Pattern.compile("[01]+");
    private static final Pattern HEX_NUMBER = Pattern.compile("[0-9a-fA-F]+");
    private int length;
    private final BitSet bitSet;

    public BitSequence() {
        this.length = 0;
        this.bitSet = new BitSet();
    }

    public BitSequence(int length) {
        this.length = length;
        this.bitSet = new BitSet(length);
    }

    public BitSequence(int length, boolean value) {
        this(length);
        this.bitSet.set(0, length, value);
    }

    public static BitSequence fromBinary(String binaryString) {
        if (!binaryString.isEmpty() && !BIN_NUMBER.matcher(binaryString).matches()) {
            throw new NumberFormatException("Invalid binary number.");
        }
        int length = binaryString.length();
        BitSequence bits = new BitSequence(length);
        for (int i = 0; i < length; ++i) {
            if (binaryString.charAt(i) != '1') continue;
            bits.set(i, true);
        }
        return bits;
    }

    public static BitSequence fromHexadecimal(String hexString) {
        if (!HEX_NUMBER.matcher(hexString).matches()) {
            throw new NumberFormatException("Invalid hexadecimal number.");
        }
        int digitCount = hexString.length();
        BitSequence bits = new BitSequence(digitCount * 4);
        for (int nibbleIndex = 0; nibbleIndex < digitCount; ++nibbleIndex) {
            int nibble = Integer.parseInt(hexString.substring(nibbleIndex, nibbleIndex + 1), 16);
            for (int bitIndex = 0; bitIndex < 4; ++bitIndex) {
                boolean bit = (nibble >>> 3 - bitIndex & 1) != 0;
                bits.set(4 * nibbleIndex + bitIndex, bit);
            }
        }
        return bits;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("Sequence index out of bounds");
        }
        return this.bitSet.get(index);
    }

    public void set(int index, boolean value) {
        this.bitSet.set(index, value);
        if (index >= this.length) {
            this.length = index + 1;
        }
    }

    public int getLength() {
        return this.length;
    }

    public boolean containsOnly(boolean value) {
        for (int i = 0; i < this.length; ++i) {
            if (this.get(i) == value) continue;
            return false;
        }
        return true;
    }

    public void append(BitSequence bits) {
        int appendedLength = bits.getLength();
        for (int i = 0; i < appendedLength; ++i) {
            this.bitSet.set(this.length + i, bits.get(i));
        }
        this.length += appendedLength;
    }

    public void append(boolean bit) {
        this.bitSet.set(this.length++, bit);
    }

    public BitSequence[] split(int bitsPerPiece) {
        int count = (int)Math.ceil((double)this.length / (double)bitsPerPiece);
        if (count == 0) {
            return new BitSequence[]{new BitSequence()};
        }
        BitSequence[] sequences = new BitSequence[count];
        for (int piece = 0; piece < count; ++piece) {
            sequences[piece] = new BitSequence();
            int start = piece * bitsPerPiece;
            int end = start + bitsPerPiece;
            for (int bit = start; bit < end && bit < this.length; ++bit) {
                sequences[piece].append(this.get(bit));
            }
        }
        return sequences;
    }

    public BitSequence subSequence(int start, int length) {
        if (start < 0 || length < 0 || start + length > this.length) {
            throw new IndexOutOfBoundsException("Sequence index out of bounds");
        }
        BitSequence sequence = new BitSequence(length);
        for (int i = 0; i < length; ++i) {
            sequence.set(i, this.get(start + i));
        }
        return sequence;
    }

    public BitSequence and(BitSequence other) {
        int resultLength = Math.min(this.length, other.length);
        BitSequence result = new BitSequence(resultLength);
        for (int i = 0; i < resultLength; ++i) {
            if (!this.get(i) || !other.get(i)) continue;
            result.set(i, true);
        }
        return result;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BitSequence)) {
            return false;
        }
        BitSequence bits = (BitSequence)object;
        return bits.length == this.length && bits.bitSet.equals(this.bitSet);
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + this.length;
        hash = 29 * hash + (this.bitSet != null ? this.bitSet.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            result.append(this.get(i) ? (char)'1' : '0');
        }
        return result.toString();
    }

    public boolean[] toBooleanArray() {
        boolean[] booleanArray = new boolean[this.length];
        for (int i = 0; i < this.length; ++i) {
            booleanArray[i] = this.get(i);
        }
        return booleanArray;
    }

    public String toHexadecimal() {
        if (this.length == 0) {
            return "";
        }
        int padBitCount = 4 - this.length % 4;
        if (padBitCount == 4) {
            padBitCount = 0;
        }
        BitSequence padded = new BitSequence(padBitCount);
        padded.append(this);
        BitSequence[] nibbles = padded.split(4);
        StringBuilder result = new StringBuilder();
        for (BitSequence nibble : nibbles) {
            int digit = 0;
            int factor = 8;
            for (int i = 0; i < 4; ++i) {
                if (nibble.get(i)) {
                    digit += factor;
                }
                factor /= 2;
            }
            result.append(Integer.toHexString(digit));
        }
        return result.toString();
    }
}

