/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.misc;

import java.io.PrintWriter;
import java.io.Writer;

public class PrettyPrinter {
    private final PrintWriter output;
    private int indentCount = 0;
    private static final String indentString = "    ";

    public PrettyPrinter(Writer output) {
        this.output = new PrintWriter(output, true);
    }

    public void writeLine(String text) {
        if (text.startsWith("}") || text.endsWith(":")) {
            this.unindent();
        }
        this.printIndentation();
        this.output.println(text);
        if (text.endsWith("{") || text.endsWith(":")) {
            this.indent();
        }
    }

    public void write(String text) {
        this.output.print(text);
    }

    private void indent() {
        ++this.indentCount;
    }

    private void unindent() {
        if (this.indentCount > 0) {
            --this.indentCount;
        }
    }

    private void printIndentation() {
        for (int i = 0; i < this.indentCount; ++i) {
            this.output.print(indentString);
        }
    }
}

