/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.nodes;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.nodes.Rule;
import net.emustudio.edigen.nodes.TreeNode;

public class Decoder
extends TreeNode {
    public static final int UNIT_SIZE_BITS = 32;
    private final Set<String> declaredRootRuleNames = new LinkedHashSet<String>();
    private final Set<Rule> rootRules = new LinkedHashSet<Rule>();

    public Decoder(Set<String> declaredRootRuleNames) {
        this.declaredRootRuleNames.addAll((Collection<String>)Objects.requireNonNull(declaredRootRuleNames));
    }

    public Decoder(String ... declaredRootRuleNames) {
        this.declaredRootRuleNames.addAll(Arrays.asList(declaredRootRuleNames));
    }

    public Decoder() {
    }

    public Set<String> getRootRuleNames() {
        if (this.declaredRootRuleNames.isEmpty()) {
            return Collections.singleton(((Rule)this.getChild(0)).getNames().get(0));
        }
        return Collections.unmodifiableSet(this.declaredRootRuleNames);
    }

    public Set<Rule> getRootRules() {
        return Collections.unmodifiableSet(this.rootRules);
    }

    public Rule getRootRule() {
        return this.rootRules.iterator().next();
    }

    public void setRootRules(Set<Rule> rootRules) {
        if (this.declaredRootRuleNames.size() != rootRules.size()) {
            throw new IllegalArgumentException("Root rule sizes do not match");
        }
        Iterator<Rule> ruleIterator = rootRules.iterator();
        for (String name : this.declaredRootRuleNames) {
            Rule rule = ruleIterator.next();
            if (rule.getNames().contains(name)) continue;
            throw new IllegalArgumentException("Declared root rule name '" + name + "' does not match with provided root rule");
        }
        this.rootRules.clear();
        this.rootRules.addAll(rootRules);
    }

    @Override
    public void accept(Visitor visitor) throws SemanticException {
        visitor.visit(this);
    }

    public String toString() {
        return "Decoder";
    }

    @Override
    public TreeNode shallowCopy() {
        Decoder cp = new Decoder(this.declaredRootRuleNames);
        cp.setRootRules(this.rootRules);
        return cp;
    }
}

