/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.nodes;

import java.util.Objects;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.misc.BitSequence;
import net.emustudio.edigen.nodes.TreeNode;

public class Mask
extends TreeNode {
    private final BitSequence bits;
    private Integer start;

    public Mask(BitSequence bits) {
        this.bits = bits;
    }

    public BitSequence getBits() {
        return this.bits;
    }

    public Integer getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public Mask and(Mask other) {
        return new Mask(this.bits.and(other.bits));
    }

    @Override
    public void accept(Visitor visitor) throws SemanticException {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Mask: " + this.bits.toString());
        if (this.start != null) {
            builder.append(", start: ").append(this.start);
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mask mask = (Mask)o;
        if (!Objects.equals(this.bits, mask.bits)) {
            return false;
        }
        return Objects.equals(this.start, mask.start);
    }

    @Override
    public int hashCode() {
        int result = this.bits != null ? this.bits.hashCode() : 0;
        result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
        return result;
    }

    @Override
    public TreeNode shallowCopy() {
        Mask cp = new Mask(this.bits);
        cp.setStart(this.start);
        return cp;
    }
}

