/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.nodes;

import java.util.Objects;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.misc.BitSequence;
import net.emustudio.edigen.nodes.Mask;
import net.emustudio.edigen.nodes.TreeNode;

public class Pattern
extends TreeNode {
    private final BitSequence bits;

    public Pattern(BitSequence bits) {
        this.bits = bits;
    }

    public BitSequence getBits() {
        return this.bits;
    }

    public Pattern and(Mask mask) {
        return new Pattern(this.bits.and(mask.getBits()));
    }

    @Override
    public void accept(Visitor visitor) throws SemanticException {
        visitor.visit(this);
    }

    public String toString() {
        return "Pattern: " + this.bits.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pattern pattern = (Pattern)o;
        return Objects.equals(this.bits, pattern.bits);
    }

    @Override
    public int hashCode() {
        return this.bits != null ? this.bits.hashCode() : 0;
    }

    @Override
    public TreeNode shallowCopy() {
        return new Pattern(this.bits);
    }
}

