/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.nodes;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.nodes.TreeNode;

public class Rule
extends TreeNode {
    private final List<String> names;
    private boolean isRoot;
    private String rootRuleName;

    public Rule(List<String> names) {
        this.names = names;
    }

    public Rule(String name) {
        this.names = Collections.singletonList(name);
    }

    public List<String> getNames() {
        return Collections.unmodifiableList(this.names);
    }

    public boolean hasOnlyOneName() {
        return this.names.size() == 1;
    }

    public String getMethodName() {
        return this.names.get(0);
    }

    public String getFieldName(String ruleName) {
        return ruleName.toUpperCase();
    }

    public String getFieldName() {
        return this.getFieldName(this.getRootRuleName());
    }

    public String getLabel() {
        Iterator<String> nameIterator = this.names.iterator();
        StringBuilder result = new StringBuilder();
        while (nameIterator.hasNext()) {
            result.append(nameIterator.next());
            if (!nameIterator.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public String getRootRuleName() {
        return this.rootRuleName;
    }

    public Rule setRoot(boolean isRoot, String rootRuleName) {
        if (!this.names.contains(rootRuleName)) {
            throw new IllegalArgumentException("Root rule name must be one of rule names!");
        }
        this.isRoot = isRoot;
        this.rootRuleName = rootRuleName;
        return this;
    }

    @Override
    public void accept(Visitor visitor) throws SemanticException {
        visitor.visit(this);
    }

    public String toString() {
        return "Rule: " + this.getLabel();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return Objects.equals(this.names, rule.names);
    }

    @Override
    public int hashCode() {
        return this.names != null ? this.names.hashCode() : 0;
    }

    @Override
    public TreeNode shallowCopy() {
        Rule cp = new Rule(this.names);
        cp.setRoot(this.isRoot, this.rootRuleName);
        return cp;
    }
}

