/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.nodes;

import java.util.Objects;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.nodes.Pattern;
import net.emustudio.edigen.nodes.Rule;
import net.emustudio.edigen.nodes.TreeNode;

public class Subrule
extends TreeNode {
    private final String name;
    private Integer start;
    private final Integer length;
    private final Pattern prePattern;
    private Rule rule;

    public Subrule(String name) {
        this(name, null);
    }

    public Subrule(String name, Pattern prePattern) {
        this(name, null, prePattern);
    }

    public Subrule(String name, Integer length, Pattern prePattern) {
        this.name = name;
        this.length = length;
        this.prePattern = prePattern;
    }

    public String getName() {
        return this.name;
    }

    public Integer getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public Integer getLength() {
        return this.length;
    }

    public Rule getRule() {
        return this.rule;
    }

    public Pattern getPrePattern() {
        return this.prePattern;
    }

    public Subrule setRule(Rule rule) {
        this.rule = rule;
        return this;
    }

    public String getFieldName() {
        return this.rule.getFieldName(this.name);
    }

    @Override
    public void accept(Visitor visitor) throws SemanticException {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Subrule: ");
        result.append(this.getName());
        if (this.start != null) {
            result.append(", start: ").append(this.start);
        }
        if (this.length != null) {
            result.append(", length: ").append(this.length);
        }
        if (this.prePattern != null) {
            result.append(", prePattern: ").append(this.prePattern.getBits());
        }
        if (this.rule != null) {
            result.append(", rule: ").append(this.rule.getLabel());
        }
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subrule subrule = (Subrule)o;
        if (!Objects.equals(this.name, subrule.name)) {
            return false;
        }
        if (!Objects.equals(this.start, subrule.start)) {
            return false;
        }
        if (!Objects.equals(this.length, subrule.length)) {
            return false;
        }
        if (!Objects.equals(this.prePattern, subrule.prePattern)) {
            return false;
        }
        return Objects.equals(this.rule, subrule.rule);
    }

    @Override
    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
        result = 31 * result + (this.length != null ? this.length.hashCode() : 0);
        result = 31 * result + (this.prePattern != null ? this.prePattern.hashCode() : 0);
        result = 31 * result + (this.rule != null ? this.rule.hashCode() : 0);
        return result;
    }

    @Override
    public TreeNode shallowCopy() {
        Subrule cp = new Subrule(this.name, this.length, this.prePattern);
        cp.setRule(this.rule);
        if (this.start != null) {
            cp.setStart(this.start);
        }
        return cp;
    }
}

