/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.nodes;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;

public abstract class TreeNode {
    private TreeNode parent;
    private final Map<String, TreeNode> children = new LinkedHashMap<String, TreeNode>();
    private Integer line;
    private final String ID = UUID.randomUUID().toString();

    public TreeNode getParent() {
        return this.parent;
    }

    public TreeNode getChild(int index) {
        Iterator<TreeNode> iterator = this.children.values().iterator();
        for (int i = 0; i < index; ++i) {
            iterator.next();
        }
        return iterator.next();
    }

    public List<TreeNode> getChildren() {
        return new ArrayList<TreeNode>(this.children.values());
    }

    public int childCount() {
        return this.children.size();
    }

    public TreeNode addChild(TreeNode child) {
        child.parent = this;
        this.children.put(child.ID, child);
        return this;
    }

    public TreeNode addChildren(TreeNode ... children) {
        for (TreeNode child : children) {
            this.addChild(child);
        }
        return this;
    }

    public TreeNode addChildren(List<TreeNode> children) {
        for (TreeNode child : children) {
            this.addChild(child);
        }
        return this;
    }

    public abstract TreeNode shallowCopy();

    public TreeNode copy() {
        TreeNode cp = this.shallowCopy();
        for (TreeNode child : this.children.values()) {
            cp.addChild(child.copy());
        }
        return cp;
    }

    public void remove() {
        this.parent.children.remove(this.ID);
        this.parent = null;
    }

    public void accept(Visitor visitor) throws SemanticException {
        visitor.visit(this);
    }

    public void acceptChildren(Visitor visitor) throws SemanticException {
        for (TreeNode child : this.getChildren()) {
            child.accept(visitor);
        }
    }

    public Integer getLine() {
        return this.line;
    }

    public void setLine(Integer line) {
        this.line = line;
    }

    public void dump(PrintStream outStream) {
        this.print(outStream, 0);
        outStream.println("---------------");
    }

    private void print(PrintStream outStream, int indent) {
        for (int i = 0; i < indent; ++i) {
            outStream.print("  ");
        }
        outStream.println(this);
        for (TreeNode child : this.getChildren()) {
            child.print(outStream, indent + 1);
        }
    }

    public int hashCode() {
        return this.ID.hashCode();
    }
}

