/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.nodes;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.nodes.Rule;
import net.emustudio.edigen.nodes.TreeNode;

public class Value
extends TreeNode {
    private final String name;
    private Rule rule;
    private List<String> strategies = Collections.emptyList();

    public Value(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public String getFieldName() {
        return this.rule.getFieldName(this.name);
    }

    public List<String> getStrategies() {
        return this.strategies;
    }

    public void setStrategies(List<String> strategies) {
        this.strategies = strategies;
    }

    @Override
    public void accept(Visitor visitor) throws SemanticException {
        visitor.visit(this);
    }

    public String toString() {
        return "Value: " + this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Value value = (Value)o;
        if (!Objects.equals(this.name, value.name)) {
            return false;
        }
        if (!Objects.equals(this.rule, value.rule)) {
            return false;
        }
        return Objects.equals(this.strategies, value.strategies);
    }

    @Override
    public TreeNode shallowCopy() {
        Value cp = new Value(this.name);
        cp.setRule(this.rule);
        cp.setStrategies(this.strategies);
        return cp;
    }
}

