/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.nodes;

import java.util.Objects;
import java.util.regex.Pattern;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.nodes.Subrule;
import net.emustudio.edigen.nodes.TreeNode;

public class Variant
extends TreeNode {
    private static final Pattern LEADING_DIGITS = Pattern.compile("\\d.*");
    private static final Pattern NON_WORD = Pattern.compile("\\W");
    private ReturnType returnType = ReturnType.NOTHING;
    private String returnString;
    private Subrule returnSubrule;

    public String getReturnString() {
        if (this.returnType == ReturnType.STRING) {
            return this.returnString;
        }
        return null;
    }

    public void setReturnString(String returnString) {
        this.returnType = ReturnType.STRING;
        this.returnString = returnString;
    }

    public Subrule getReturnSubrule() {
        if (this.returnType == ReturnType.SUBRULE) {
            return this.returnSubrule;
        }
        return null;
    }

    public void setReturnSubrule(Subrule returnRule) {
        this.returnType = ReturnType.SUBRULE;
        this.returnSubrule = returnRule;
    }

    public boolean returns() {
        return this.returnType != ReturnType.NOTHING;
    }

    public String getFieldName() {
        if (this.returnType == ReturnType.STRING) {
            return this.makeIdentifierName(this.returnString);
        }
        return null;
    }

    @Override
    public void accept(Visitor visitor) throws SemanticException {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Variant");
        if (this.returnType == ReturnType.STRING) {
            result.append(": return \"").append(this.returnString).append('\"');
        } else if (this.returnType == ReturnType.SUBRULE) {
            result.append(": return ").append(this.returnSubrule);
        }
        return result.toString();
    }

    private String makeIdentifierName(String string) {
        if (LEADING_DIGITS.matcher((CharSequence)(string = ((String)string).trim().toUpperCase())).matches()) {
            string = "_" + (String)string;
        }
        string = ((String)string).replace(' ', '_');
        return NON_WORD.matcher((CharSequence)string).replaceAll("_");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variant variant = (Variant)o;
        if (this.returnType != variant.returnType) {
            return false;
        }
        if (!Objects.equals(this.returnString, variant.returnString)) {
            return false;
        }
        return Objects.equals(this.returnSubrule, variant.returnSubrule);
    }

    @Override
    public TreeNode shallowCopy() {
        Variant cp = new Variant();
        cp.returnType = this.returnType;
        cp.returnString = this.returnString;
        cp.returnSubrule = this.returnSubrule;
        return cp;
    }

    private static enum ReturnType {
        NOTHING,
        STRING,
        SUBRULE;

    }
}

