/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.passes;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.nodes.Decoder;
import net.emustudio.edigen.nodes.Rule;

public class DetectRootRulesVisitor
extends Visitor {
    private final Set<String> rootRuleNames = new LinkedHashSet<String>();
    private final Map<String, Rule> rootRulesByName = new HashMap<String, Rule>();
    private final Set<String> visitedRuleNames = new HashSet<String>();

    @Override
    public void visit(Decoder decoder) throws SemanticException {
        this.rootRuleNames.addAll(decoder.getRootRuleNames());
        decoder.acceptChildren(this);
        if (!this.rootRuleNames.isEmpty()) {
            throw new SemanticException("Root rules were not defined: " + this.rootRuleNames, decoder);
        }
        LinkedHashSet<Rule> rootRules = new LinkedHashSet<Rule>();
        for (String name : decoder.getRootRuleNames()) {
            rootRules.add(this.rootRulesByName.get(name));
        }
        decoder.setRootRules(rootRules);
    }

    @Override
    public void visit(Rule rule) throws SemanticException {
        for (String name : rule.getNames()) {
            if (this.visitedRuleNames.contains(name)) {
                throw new SemanticException("The rule was declared as root more than once (with another name)", rule);
            }
            if (!this.rootRuleNames.remove(name)) continue;
            rule.setRoot(true, name);
            this.rootRulesByName.put(name, rule);
            this.visitedRuleNames.addAll(rule.getNames());
        }
    }
}

