/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.passes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.nodes.Decoder;
import net.emustudio.edigen.nodes.Disassembler;
import net.emustudio.edigen.nodes.Format;
import net.emustudio.edigen.nodes.Rule;
import net.emustudio.edigen.nodes.Subrule;
import net.emustudio.edigen.nodes.TreeNode;
import net.emustudio.edigen.nodes.Value;
import net.emustudio.edigen.nodes.Variant;

public class DetectUnreachableFormatsVisitor
extends Visitor {
    private final Set<Set<String>> reachable = new HashSet<Set<String>>();
    private final Set<Set<String>> formats = new HashSet<Set<String>>();
    private Set<String> currentFormat;

    public Set<Set<String>> getReachable() {
        return new HashSet<Set<String>>(this.reachable);
    }

    @Override
    public void visit(Decoder decoder) throws SemanticException {
        BuildSlimTreeVisitor slimTreeVisitor = new BuildSlimTreeVisitor();
        for (Rule rule : decoder.getRootRules()) {
            rule.accept(slimTreeVisitor);
        }
        List<Rule> slimTree = slimTreeVisitor.slimTree;
        List<EliminateVariantsVisitor> additionalVisitors = List.of(new RemoveOrphanSubrulesVisitor(), new UniqueSubrulePathsVisitor(), new EliminateVariantsVisitor());
        for (Rule rule : slimTree) {
            for (Visitor visitor : additionalVisitors) {
                rule.accept(visitor);
            }
            CollectPathsVisitor collectVisitor = new CollectPathsVisitor();
            rule.accept(collectVisitor);
            this.reachable.addAll(collectVisitor.allPaths);
        }
    }

    @Override
    public void visit(Disassembler disassembler) throws SemanticException {
        disassembler.acceptChildren(this);
        if (!this.reachable.containsAll(this.formats)) {
            HashSet<Set<String>> cp = new HashSet<Set<String>>(this.formats);
            cp.removeAll(this.reachable);
            throw new SemanticException("Unreachable formats: " + cp, disassembler);
        }
        if (!this.formats.containsAll(this.reachable)) {
            HashSet<Set<String>> cp = new HashSet<Set<String>>(this.reachable);
            cp.removeAll(this.formats);
            System.out.println("Missing formats: " + cp);
        }
    }

    @Override
    public void visit(Format format) throws SemanticException {
        this.currentFormat = new HashSet<String>();
        format.acceptChildren(this);
        if (!this.currentFormat.isEmpty()) {
            this.formats.add(this.currentFormat);
        }
    }

    @Override
    public void visit(Value value) throws SemanticException {
        this.currentFormat.add(value.getName());
    }

    private static class CollectPathsVisitor
    extends Visitor {
        final Set<Set<String>> allPaths = new HashSet<Set<String>>();
        private Set<String> currentPath = new HashSet<String>();

        private CollectPathsVisitor() {
        }

        @Override
        public void visit(Subrule subrule) throws SemanticException {
            HashSet<String> old = new HashSet<String>(this.currentPath);
            this.currentPath.add(subrule.getName());
            if (subrule.childCount() == 0) {
                this.allPaths.add(this.currentPath);
            } else {
                subrule.acceptChildren(this);
            }
            this.currentPath = old;
        }
    }

    private static class EliminateVariantsVisitor
    extends Visitor {
        private EliminateVariantsVisitor() {
        }

        @Override
        public void visit(Variant variant) throws SemanticException {
            variant.acceptChildren(this);
            TreeNode parent = variant.getParent();
            List<TreeNode> children = variant.getChildren();
            children.forEach(TreeNode::remove);
            if (!variant.returns() && parent != null) {
                TreeNode parentParent = parent.getParent();
                if (parentParent != null) {
                    parentParent.addChildren(children);
                    if (parent.childCount() == 1) {
                        parent.remove();
                    }
                } else {
                    parent.addChildren(children);
                }
            } else if (parent != null) {
                if (parent instanceof Rule) {
                    Subrule artificial = new Subrule(((Rule)parent).getNames().get(0));
                    artificial.addChildren(children);
                    parent.addChild(artificial);
                } else if (children.isEmpty()) {
                    Subrule artificial = new Subrule(((Subrule)parent).getName());
                    parent.addChild(artificial);
                } else {
                    parent.addChildren(children);
                }
            }
            variant.remove();
        }
    }

    private static class UniqueSubrulePathsVisitor
    extends Visitor {
        private UniqueSubrulePathsVisitor() {
        }

        @Override
        public void visit(Variant variant) throws SemanticException {
            variant.acceptChildren(this);
            ArrayList children = new ArrayList();
            variant.getChildren().forEach(t -> children.add((Subrule)t));
            if (!children.isEmpty()) {
                Subrule firstChild = (Subrule)children.get(0);
                children.remove(0);
                for (Subrule child : children) {
                    child.remove();
                    this.addRecursively(firstChild, child);
                }
            }
        }

        private void addRecursively(TreeNode where, TreeNode what) {
            if (where.childCount() == 0) {
                where.addChild(what.copy());
            } else {
                for (TreeNode child : where.getChildren()) {
                    this.addRecursively(child, what);
                }
            }
        }
    }

    private static class RemoveOrphanSubrulesVisitor
    extends Visitor {
        private RemoveOrphanSubrulesVisitor() {
        }

        @Override
        public void visit(Subrule subrule) throws SemanticException {
            if (subrule.childCount() == 0) {
                subrule.remove();
            } else {
                subrule.acceptChildren(this);
            }
        }
    }

    private static class BuildSlimTreeVisitor
    extends Visitor {
        final List<Rule> slimTree = new ArrayList<Rule>();
        private TreeNode current;

        private BuildSlimTreeVisitor() {
        }

        @Override
        public void visit(Rule rule) throws SemanticException {
            Rule newCurrent = new Rule(rule.getNames());
            if (rule.getRootRuleName() != null) {
                newCurrent.setRoot(rule.isRoot(), rule.getRootRuleName());
            }
            if (rule.isRoot()) {
                this.slimTree.add(newCurrent);
            }
            this.current = newCurrent;
            rule.acceptChildren(this);
            this.current = newCurrent;
        }

        @Override
        public void visit(Variant variant) throws SemanticException {
            TreeNode old = this.current;
            Variant newCurrent = new Variant();
            if (variant.getReturnString() != null) {
                newCurrent.setReturnString(variant.getReturnString());
            } else if (variant.getReturnSubrule() != null) {
                Subrule newSubrule = new Subrule(variant.getReturnSubrule().getName());
                if (variant.getReturnSubrule().getRule() != null) {
                    variant.getReturnSubrule().getRule().accept(this);
                    newSubrule.setRule((Rule)this.current);
                    this.current = old;
                }
                newCurrent.setReturnSubrule(newSubrule);
            }
            this.current.addChild(newCurrent);
            this.current = newCurrent;
            variant.acceptChildren(this);
            this.current = old;
        }

        @Override
        public void visit(Subrule subrule) throws SemanticException {
            TreeNode old = this.current;
            Subrule newCurrent = new Subrule(subrule.getName());
            this.current.addChild(newCurrent);
            if (subrule.getRule() != null) {
                this.current = newCurrent;
                subrule.getRule().acceptChildren(this);
                this.current = old;
            }
        }
    }
}

