/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.passes;

import java.util.HashSet;
import java.util.Set;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.nodes.Decoder;
import net.emustudio.edigen.nodes.Rule;
import net.emustudio.edigen.nodes.Subrule;

public class DetectUnusedRulesVisitor
extends Visitor {
    private static final String MESSAGE = "Unused rule detected: \"%s\"";
    private boolean rootRuleVisited;
    private final Set<String> knownRules = new HashSet<String>();

    @Override
    public void visit(Decoder decoder) throws SemanticException {
        this.knownRules.addAll(decoder.getRootRuleNames());
        decoder.acceptChildren(this);
    }

    @Override
    public void visit(Rule rule) throws SemanticException {
        if (!this.rootRuleVisited) {
            this.rootRuleVisited = true;
            this.knownRules.addAll(rule.getNames());
            rule.acceptChildren(this);
        }
        if (this.isUnknown(rule)) {
            throw new SemanticException(String.format(MESSAGE, rule.getLabel()), rule);
        }
    }

    @Override
    public void visit(Subrule subrule) throws SemanticException {
        Rule rule = subrule.getRule();
        if (rule != null && this.isUnknown(rule)) {
            this.knownRules.addAll(rule.getNames());
            rule.acceptChildren(this);
        }
    }

    private boolean isUnknown(Rule rule) {
        for (String name : rule.getNames()) {
            if (!this.knownRules.contains(name)) continue;
            return false;
        }
        return true;
    }
}

