/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.passes;

import java.util.LinkedHashMap;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.misc.BitSequence;
import net.emustudio.edigen.nodes.Mask;
import net.emustudio.edigen.nodes.Pattern;
import net.emustudio.edigen.nodes.Rule;
import net.emustudio.edigen.nodes.TreeNode;

public class GroupVisitor
extends Visitor {
    private boolean savingBits;
    private BitSequence savedBits;

    @Override
    public void visit(Rule rule) throws SemanticException {
        this.group(rule);
    }

    @Override
    public void visit(Mask mask) throws SemanticException {
        if (this.savingBits) {
            this.savedBits = mask.getBits();
        } else {
            this.group(mask);
        }
    }

    @Override
    public void visit(Pattern pattern) throws SemanticException {
        if (this.savingBits) {
            this.savedBits = pattern.getBits();
        } else {
            this.group(pattern);
        }
    }

    private void group(TreeNode node) throws SemanticException {
        LinkedHashMap<BitSequence, TreeNode> uniqueChildren = new LinkedHashMap<BitSequence, TreeNode>();
        for (TreeNode child : node.getChildren()) {
            this.savedBits = null;
            this.savingBits = true;
            child.accept(this);
            if (this.savedBits == null) continue;
            TreeNode uniqueChild = (TreeNode)uniqueChildren.get(this.savedBits);
            if (uniqueChild == null) {
                uniqueChildren.put(this.savedBits, child);
                continue;
            }
            child.remove();
            uniqueChild.addChild(child.getChild(0));
        }
        this.savingBits = false;
        node.acceptChildren(this);
    }
}

