/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.passes;

import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.misc.BitSequence;
import net.emustudio.edigen.nodes.Mask;
import net.emustudio.edigen.nodes.Pattern;
import net.emustudio.edigen.nodes.Subrule;
import net.emustudio.edigen.nodes.Variant;

public class MergePatternsVisitor
extends Visitor {
    private BitSequence maskBits;
    private BitSequence patternBits;

    @Override
    public void visit(Variant variant) throws SemanticException {
        this.maskBits = new BitSequence();
        this.patternBits = new BitSequence();
        variant.acceptChildren(this);
        variant.addChild(new Mask(this.maskBits));
        variant.addChild(new Pattern(this.patternBits));
    }

    @Override
    public void visit(Pattern pattern) {
        int bitCount = pattern.getBits().getLength();
        this.maskBits.append(new BitSequence(bitCount, true));
        this.patternBits.append(pattern.getBits());
        pattern.remove();
    }

    @Override
    public void visit(Subrule subrule) throws SemanticException {
        subrule.setStart(this.maskBits.getLength());
        Integer bitCount = subrule.getLength();
        Pattern prePattern = subrule.getPrePattern();
        if (bitCount != null) {
            if (prePattern != null) {
                BitSequence prePatternBS = prePattern.getBits();
                int prePatternLen = prePatternBS.getLength();
                if (prePatternLen > bitCount) {
                    throw new SemanticException("Pre-pattern length is longer than expected for subrule " + subrule.getName(), subrule);
                }
                this.maskBits.append(new BitSequence(prePatternLen, true));
                this.patternBits.append(prePatternBS);
                if (prePatternLen < bitCount) {
                    int diff = bitCount - prePatternLen;
                    this.maskBits.append(new BitSequence(diff, false));
                    this.patternBits.append(new BitSequence(diff, false));
                }
            } else {
                this.maskBits.append(new BitSequence(bitCount, false));
                this.patternBits.append(new BitSequence(bitCount, false));
            }
        }
        if (subrule.getRule() == null) {
            subrule.remove();
        }
    }
}

