/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.passes;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.nodes.Decoder;
import net.emustudio.edigen.nodes.Rule;
import net.emustudio.edigen.nodes.Subrule;
import net.emustudio.edigen.nodes.TreeNode;
import net.emustudio.edigen.nodes.Value;
import net.emustudio.edigen.nodes.Variant;

public class ResolveNamesVisitor
extends Visitor {
    private final Map<String, Rule> rules = new LinkedHashMap<String, Rule>();
    private final List<Rule> inferredRules = new ArrayList<Rule>();
    private final Set<String> ruleFieldNames = new LinkedHashSet<String>();
    private String searchedSubrule;
    private Subrule foundSubrule;

    @Override
    public void visit(Decoder decoder) throws SemanticException {
        decoder.acceptChildren(this);
        for (TreeNode rule : decoder.getChildren()) {
            rule.acceptChildren(this);
        }
        decoder.addChildren(this.inferredRules.toArray(new Rule[0]));
    }

    @Override
    public void visit(Rule rule) throws SemanticException {
        for (String name : rule.getNames()) {
            if (!this.rules.containsKey(name)) {
                this.rules.put(name, rule);
                String field = rule.getFieldName(name);
                if (!this.ruleFieldNames.contains(field)) {
                    this.ruleFieldNames.add(field);
                    continue;
                }
                throw new SemanticException("Rule field \"" + field + "\" is generated multiple times", rule);
            }
            throw new SemanticException("Rule \"" + name + "\" is defined multiple times", rule);
        }
    }

    @Override
    public void visit(Variant variant) throws SemanticException {
        this.searchedSubrule = variant.getReturnSubrule() == null ? null : variant.getReturnSubrule().getName();
        this.foundSubrule = null;
        variant.acceptChildren(this);
        if (this.searchedSubrule != null) {
            if (this.foundSubrule != null) {
                variant.setReturnSubrule(this.foundSubrule);
            } else {
                throw new SemanticException("Variant returns nonexistent subrule \"" + this.searchedSubrule + "\"", variant);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visit(Subrule subrule) throws SemanticException {
        if (subrule.getLength() != null && subrule.getName().equals(this.searchedSubrule)) {
            if (this.foundSubrule != null) throw new SemanticException("Subrule \"" + this.searchedSubrule + "\" is present multiple times in a variant which returns it", subrule);
            this.foundSubrule = subrule;
            return;
        } else {
            Rule rule = this.rules.get(subrule.getName());
            if (rule != null) {
                subrule.setRule(rule);
                return;
            } else {
                if (subrule.getLength() == null) throw new SemanticException("Subrule \"" + subrule.getName() + "\" refers to a nonexistent rule", subrule);
                Rule inferred = this.inferImplicitRule(subrule);
                this.rules.put(subrule.getName(), inferred);
                this.inferredRules.add(inferred);
                subrule.setRule(inferred);
            }
        }
    }

    @Override
    public void visit(Value value) throws SemanticException {
        String name = value.getName();
        Rule rule = this.rules.get(name);
        if (rule == null) {
            throw new SemanticException("Disassembler value \"" + name + "\" refers to a nonexistent rule", value);
        }
        value.setRule(rule);
    }

    private Rule inferImplicitRule(Subrule originalSubrule) {
        Rule rule = new Rule(originalSubrule.getName());
        Variant variant = new Variant();
        Subrule subrule = new Subrule("arg", originalSubrule.getLength(), originalSubrule.getPrePattern());
        variant.addChild(subrule);
        variant.setReturnSubrule(subrule);
        rule.addChild(variant);
        return rule;
    }
}

