/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.passes;

import java.util.HashSet;
import java.util.Set;
import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.nodes.Format;
import net.emustudio.edigen.nodes.Pattern;
import net.emustudio.edigen.nodes.Rule;
import net.emustudio.edigen.nodes.Subrule;
import net.emustudio.edigen.nodes.Value;
import net.emustudio.edigen.nodes.Variant;

public class SemanticCheckVisitor
extends Visitor {
    private final Set<Set<String>> formatSet = new HashSet<Set<String>>();
    private final Set<String> valueSet = new HashSet<String>();
    private boolean variantReturns;
    private final Set<String> returningRules = new HashSet<String>();
    private Subrule subruleWithoutLength;

    @Override
    public void visit(Rule rule) throws SemanticException {
        this.variantReturns = false;
        rule.acceptChildren(this);
        if (this.variantReturns) {
            this.returningRules.addAll(rule.getNames());
        }
    }

    @Override
    public void visit(Variant variant) throws SemanticException {
        if (variant.returns()) {
            this.variantReturns = true;
        }
        this.subruleWithoutLength = null;
        variant.acceptChildren(this);
    }

    @Override
    public void visit(Pattern pattern) throws SemanticException {
        this.checkSubruleWithoutLength();
    }

    @Override
    public void visit(Subrule subrule) throws SemanticException {
        this.checkSubruleWithoutLength();
        if (subrule.getLength() == null) {
            this.subruleWithoutLength = subrule;
        }
    }

    @Override
    public void visit(Format format) throws SemanticException {
        this.valueSet.clear();
        format.acceptChildren(this);
        if (this.formatSet.contains(this.valueSet)) {
            StringBuilder values = new StringBuilder();
            for (String value : this.valueSet) {
                if (values.length() != 0) {
                    values.append(", ");
                }
                values.append(value);
            }
            throw new SemanticException("Set of values \"" + values + "\" is contained in multiple disassembler formats", format);
        }
        this.formatSet.add(this.valueSet);
    }

    @Override
    public void visit(Value value) throws SemanticException {
        if (!this.returningRules.contains(value.getName())) {
            throw new SemanticException("Rule \"" + value.getName() + "\" never returns a value, but is used in the disassembler", value);
        }
        this.valueSet.add(value.getName());
    }

    private void checkSubruleWithoutLength() throws SemanticException {
        if (this.subruleWithoutLength != null) {
            String name = this.subruleWithoutLength.getName();
            String message = "Subrule \"" + name + "\" does not have a specified length and is not contained at the variant end";
            throw new SemanticException(message, this.subruleWithoutLength);
        }
    }
}

