/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.passes;

import net.emustudio.edigen.SemanticException;
import net.emustudio.edigen.Visitor;
import net.emustudio.edigen.misc.BitSequence;
import net.emustudio.edigen.nodes.Mask;
import net.emustudio.edigen.nodes.Pattern;
import net.emustudio.edigen.nodes.TreeNode;
import net.emustudio.edigen.nodes.Variant;

public class SplitVisitor
extends Visitor {
    private BitSequence maskBits;
    private BitSequence patternBits;

    @Override
    public void visit(Variant variant) throws SemanticException {
        variant.acceptChildren(this);
        BitSequence[] masks = this.maskBits.split(32);
        BitSequence[] patterns = this.patternBits.split(32);
        TreeNode parent = variant;
        for (int i = 0; i < masks.length; ++i) {
            Mask mask = new Mask(masks[i]);
            mask.setStart(i * 32);
            Pattern pattern = new Pattern(patterns[i]);
            parent.addChild(mask);
            mask.addChild(pattern);
            parent = pattern;
        }
    }

    @Override
    public void visit(Mask mask) {
        this.maskBits = mask.getBits();
        mask.remove();
    }

    @Override
    public void visit(Pattern pattern) {
        this.patternBits = pattern.getBits();
        pattern.remove();
    }
}

