/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.ui;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.emustudio.edigen.Setting;

public class Argument {
    private static final Pattern HELP_VALUE = Pattern.compile("<\\w+>");
    private final Type type;
    private final String option;
    private final String value;
    private final String description;
    private final Setting key;

    public Argument(String description, Setting key) {
        this.type = Type.MANDATORY;
        this.option = "";
        Matcher matcher = HELP_VALUE.matcher(description);
        this.value = matcher.find() ? matcher.group() : "<value>";
        this.description = description;
        this.key = key;
    }

    public Argument(String option, String description, Setting key) {
        Matcher matcher = HELP_VALUE.matcher(description);
        if (matcher.find()) {
            this.type = Type.VALUE;
            this.value = matcher.group();
        } else {
            this.type = Type.FLAG;
            this.value = "";
        }
        this.option = option;
        this.description = description;
        this.key = key;
    }

    public Type getType() {
        return this.type;
    }

    public String getOption() {
        return this.option;
    }

    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public Setting getKey() {
        return this.key;
    }

    public static enum Type {
        MANDATORY,
        VALUE,
        FLAG;

    }
}

