/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.emustudio.edigen.Setting;
import net.emustudio.edigen.ui.Argument;
import net.emustudio.edigen.ui.CommandLineException;

public class CommandLine {
    private final List<Argument> mandatory = new ArrayList<Argument>();
    private final Map<String, Argument> optional = new LinkedHashMap<String, Argument>();
    private Map<Setting, String> configuration;

    public CommandLine(Argument[] arguments) {
        for (Argument argument : arguments) {
            if (argument.getType() == Argument.Type.MANDATORY) {
                this.mandatory.add(argument);
                continue;
            }
            this.optional.put(argument.getOption(), argument);
        }
    }

    public Map<Setting, String> parse(String[] arguments) throws CommandLineException {
        this.configuration = new EnumMap<Setting, String>(Setting.class);
        Iterator<Argument> expectedMandatory = this.mandatory.iterator();
        Iterator<String> allArguments = Arrays.asList(arguments).iterator();
        while (allArguments.hasNext()) {
            String currentArgument = allArguments.next();
            if (currentArgument.startsWith("-")) {
                this.parseOptional(currentArgument, allArguments);
                continue;
            }
            this.parseMandatory(currentArgument, expectedMandatory);
        }
        if (expectedMandatory.hasNext()) {
            throw new CommandLineException("Too few arguments given");
        }
        return this.configuration;
    }

    public Iterable<Argument> getMandatoryArguments() {
        return this.mandatory;
    }

    public Iterable<Argument> getOptionalArguments() {
        return this.optional.values();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseOptional(String current, Iterator<String> all) throws CommandLineException {
        String option = current.substring(1);
        Argument argument = this.optional.get(option);
        if (argument == null) throw new CommandLineException("Unknown option \"-" + option + "\"");
        if (argument.getType() == Argument.Type.FLAG) {
            this.configuration.put(argument.getKey(), "");
            return;
        } else {
            if (!all.hasNext() || (current = all.next()).startsWith("-")) throw new CommandLineException("Option \"-" + option + "\" does not have a value");
            this.configuration.put(argument.getKey(), current);
        }
    }

    private void parseMandatory(String argument, Iterator<Argument> expected) throws CommandLineException {
        if (!expected.hasNext()) {
            throw new CommandLineException("Too many arguments given");
        }
        this.configuration.put(expected.next().getKey(), argument);
    }
}

