/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.edigen.ui;

import net.emustudio.edigen.ui.Argument;
import net.emustudio.edigen.ui.CommandLine;

public class Help {
    private final String executionCommand;
    private final CommandLine commandLine;

    public Help(String executionCommand, CommandLine commandLine) {
        this.executionCommand = executionCommand;
        this.commandLine = commandLine;
    }

    public String generate() {
        StringBuilder help = new StringBuilder("Usage:\n ");
        help.append(this.executionCommand);
        this.generateMandatory(help);
        this.generateOptional(help);
        return help.toString();
    }

    private void generateMandatory(StringBuilder help) {
        for (Argument argument : this.commandLine.getMandatoryArguments()) {
            help.append(' ').append(argument.getValue());
        }
        help.append(" [options...]\n\n");
        for (Argument argument : this.commandLine.getMandatoryArguments()) {
            help.append(' ').append(argument.getDescription()).append('\n');
        }
        help.append('\n');
    }

    private void generateOptional(StringBuilder help) {
        help.append("Supported options:\n");
        for (Argument argument : this.commandLine.getOptionalArguments()) {
            Object definition = argument.getOption();
            if (argument.getType() == Argument.Type.VALUE) {
                definition = (String)definition + " " + argument.getValue();
            }
            String line = String.format(" -%-15s %s", definition, argument.getDescription());
            help.append(line).append('\n');
        }
    }
}

