/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.emulib.plugins.compiler;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JFrame;
import net.emustudio.emulib.plugins.PluginInitializationException;
import net.emustudio.emulib.plugins.annotations.PluginRoot;
import net.emustudio.emulib.plugins.compiler.Compiler;
import net.emustudio.emulib.plugins.compiler.CompilerListener;
import net.emustudio.emulib.plugins.compiler.CompilerMessage;
import net.emustudio.emulib.runtime.ApplicationApi;
import net.emustudio.emulib.runtime.settings.PluginSettings;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractCompiler
implements Compiler {
    protected final long pluginID;
    protected final ApplicationApi applicationApi;
    protected final PluginSettings settings;
    private final Set<CompilerListener> compilerListeners = new CopyOnWriteArraySet<CompilerListener>();

    public AbstractCompiler(long pluginID, ApplicationApi applicationApi, PluginSettings settings) {
        this.pluginID = pluginID;
        this.applicationApi = Objects.requireNonNull(applicationApi);
        this.settings = Objects.requireNonNull(settings);
    }

    @Override
    public void initialize() throws PluginInitializationException {
    }

    @Override
    public void destroy() {
    }

    @Override
    public String getTitle() {
        return this.getClass().getAnnotation(PluginRoot.class).title();
    }

    @Override
    public void showSettings(JFrame parent) {
    }

    @Override
    public boolean isShowSettingsSupported() {
        return false;
    }

    @Override
    public void addCompilerListener(CompilerListener listener) {
        this.compilerListeners.add(listener);
    }

    @Override
    public void removeCompilerListener(CompilerListener listener) {
        this.compilerListeners.remove(listener);
    }

    protected void notifyCompileStart() {
        this.compilerListeners.forEach(CompilerListener::onStart);
    }

    protected void notifyCompileFinish() {
        this.compilerListeners.forEach(CompilerListener::onFinish);
    }

    public void notifyOnMessage(CompilerMessage compilerMessage) {
        this.compilerListeners.forEach(listener -> listener.onMessage(compilerMessage));
    }

    public void notifyError(String msg) {
        this.notifyOnMessage(new CompilerMessage(CompilerMessage.MessageType.TYPE_ERROR, msg));
    }

    public void notifyError(int line, int column, String msg) {
        this.notifyOnMessage(new CompilerMessage(CompilerMessage.MessageType.TYPE_ERROR, msg, line, column));
    }

    public void notifyInfo(String msg) {
        this.notifyOnMessage(new CompilerMessage(CompilerMessage.MessageType.TYPE_INFO, msg));
    }

    public void notifyInfo(int line, int column, String msg) {
        this.notifyOnMessage(new CompilerMessage(CompilerMessage.MessageType.TYPE_INFO, msg, line, column));
    }

    public void notifyWarning(String msg) {
        this.notifyOnMessage(new CompilerMessage(CompilerMessage.MessageType.TYPE_WARNING, msg));
    }

    public void notifyWarning(int line, int column, String msg) {
        this.notifyOnMessage(new CompilerMessage(CompilerMessage.MessageType.TYPE_WARNING, msg, line, column));
    }

    @Override
    public void reset() {
    }
}

