/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.emulib.plugins.compiler;

import java.util.Objects;

public class CompilerMessage {
    public static final String MSG_INFO = "[INFO   ] ";
    public static final String MSG_ERROR = "[ERROR  ] ";
    public static final String MSG_WARNING = "[WARNING] ";
    public static final String POSITION_FORMAT = "(%3d,%3d) ";
    private final MessageType messageType;
    private final String message;
    private final int line;
    private final int column;

    public CompilerMessage(MessageType messageType, String message, int line, int column) {
        this.messageType = Objects.requireNonNull(messageType);
        this.message = Objects.requireNonNull(message);
        this.line = line;
        this.column = column;
    }

    public CompilerMessage(String message) {
        this(MessageType.TYPE_UNKNOWN, message, -1, -1);
    }

    public CompilerMessage(MessageType type, String message) {
        this(type, message, -1, -1);
    }

    public String getFormattedMessage() {
        StringBuilder mes = new StringBuilder();
        switch (this.messageType) {
            case TYPE_WARNING: {
                mes.append(MSG_WARNING);
                break;
            }
            case TYPE_ERROR: {
                mes.append(MSG_ERROR);
                break;
            }
            case TYPE_INFO: {
                mes.append(MSG_INFO);
            }
        }
        if (this.line >= 0 || this.column >= 0) {
            mes.append(String.format(POSITION_FORMAT, this.line, this.column));
        }
        mes.append(this.message);
        return mes.toString();
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getMessage() {
        return this.message;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public String toString() {
        return this.getFormattedMessage();
    }

    public static enum MessageType {
        TYPE_WARNING,
        TYPE_ERROR,
        TYPE_INFO,
        TYPE_UNKNOWN;

    }
}

