/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.emulib.plugins.compiler;

import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class FileExtension {
    private final String extension;
    private final String description;

    public FileExtension(String extension, String description) {
        this.extension = Objects.requireNonNull(extension);
        this.description = Objects.requireNonNull(description);
    }

    public String getExtension() {
        return this.extension;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileExtension that = (FileExtension)o;
        return this.extension.equals(that.extension);
    }

    public int hashCode() {
        return Objects.hash(this.extension);
    }

    public static String stripKnownExtension(String fileName, Iterable<FileExtension> knownExtensions) {
        for (FileExtension extension : knownExtensions) {
            int i = fileName.lastIndexOf("." + extension.getExtension());
            if (i < 0) continue;
            return fileName.substring(0, i);
        }
        return fileName;
    }
}

