/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.emulib.plugins.cpu;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFrame;
import net.emustudio.emulib.plugins.annotations.PluginRoot;
import net.emustudio.emulib.plugins.cpu.CPU;
import net.emustudio.emulib.runtime.ApplicationApi;
import net.emustudio.emulib.runtime.settings.PluginSettings;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractCPU
implements CPU,
Callable<CPU.RunState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCPU.class);
    private static final Runnable EMPTY_TASK = () -> {};
    private final AtomicBoolean isDestroyed = new AtomicBoolean();
    private final ExecutorService eventReceiver = Executors.newSingleThreadExecutor();
    private final ExecutorService cpuExecutor = Executors.newSingleThreadExecutor();
    private final ExecutorService cpuStoppedWatcher = Executors.newSingleThreadExecutor();
    private final Set<CPU.CPUListener> stateObservers = new CopyOnWriteArraySet<CPU.CPUListener>();
    private final Set<Integer> breakpoints = new ConcurrentSkipListSet<Integer>();
    private volatile CPU.RunState runState = CPU.RunState.STATE_STOPPED_NORMAL;
    private volatile CPUWatchTask cpuWatchTask;
    protected final long pluginID;
    protected final ApplicationApi applicationApi;
    protected final PluginSettings settings;

    public AbstractCPU(long pluginID, ApplicationApi applicationApi, PluginSettings settings) {
        this.pluginID = pluginID;
        this.applicationApi = Objects.requireNonNull(applicationApi);
        this.settings = Objects.requireNonNull(settings);
    }

    @Override
    public String getTitle() {
        return this.getClass().getAnnotation(PluginRoot.class).title();
    }

    @Override
    public void showSettings(JFrame parent) {
    }

    @Override
    public boolean isShowSettingsSupported() {
        return false;
    }

    @Override
    public boolean isBreakpointSupported() {
        return true;
    }

    @Override
    public void setBreakpoint(int location) {
        this.breakpoints.add(location);
    }

    @Override
    public void unsetBreakpoint(int location) {
        this.breakpoints.remove(location);
    }

    @Override
    public boolean isBreakpointSet(int location) {
        return this.breakpoints.contains(location);
    }

    @Override
    public void addCPUListener(CPU.CPUListener listener) {
        this.stateObservers.add(listener);
    }

    @Override
    public void removeCPUListener(CPU.CPUListener listener) {
        this.stateObservers.remove(listener);
    }

    private void stopExecutor(ExecutorService executor) {
        Objects.requireNonNull(executor);
        executor.shutdown();
        try {
            if (!executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void destroy() {
        if (this.isDestroyed.compareAndSet(false, true)) {
            try {
                this.stop();
                this.stopExecutor(this.eventReceiver);
                this.stopExecutor(this.cpuExecutor);
                this.stopExecutor(this.cpuStoppedWatcher);
                this.stateObservers.clear();
            }
            finally {
                this.destroyInternal();
            }
        }
    }

    protected abstract void destroyInternal();

    private void waitForFuture(Future<?> future) {
        Objects.requireNonNull(future);
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOGGER.error("Unexpected error", (Throwable)e);
        }
    }

    private void notifyStateChanged(CPU.RunState tmpRunState) {
        this.stateObservers.forEach(observer -> {
            try {
                observer.runStateChanged(tmpRunState);
                observer.internalStateChanged();
            }
            catch (Exception e) {
                LOGGER.error("CPU Listener error", (Throwable)e);
            }
        });
    }

    private void ensureCpuIsStopped() {
        try {
            this.cpuStoppedWatcher.submit(EMPTY_TASK).get();
        }
        catch (ExecutionException e) {
            LOGGER.error("Unexpected error while waiting for CPU stop", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void reset() {
        this.reset(this.applicationApi.getProgramLocation());
    }

    @Override
    public void reset(int location) {
        Future<?> future = this.eventReceiver.submit(() -> {
            CPU.RunState tmpRunState;
            this.requestStop();
            this.ensureCpuIsStopped();
            this.resetInternal(location);
            this.runState = tmpRunState = CPU.RunState.STATE_STOPPED_BREAK;
            this.notifyStateChanged(tmpRunState);
        });
        this.waitForFuture(future);
    }

    @Override
    public void execute() {
        Future<?> future = this.eventReceiver.submit(() -> {
            if (this.runState == CPU.RunState.STATE_STOPPED_BREAK) {
                CPU.RunState tmpRunState;
                this.runState = tmpRunState = CPU.RunState.STATE_RUNNING;
                this.notifyStateChanged(tmpRunState);
                Future<CPU.RunState> cpuFuture = this.cpuExecutor.submit(this);
                this.cpuWatchTask = new CPUWatchTask(cpuFuture);
                this.cpuStoppedWatcher.submit(this.cpuWatchTask);
            }
        });
        this.waitForFuture(future);
    }

    @Override
    public void pause() {
        Future<?> future = this.eventReceiver.submit(() -> {
            if (this.runState == CPU.RunState.STATE_RUNNING) {
                this.requestStop();
                this.ensureCpuIsStopped();
                CPU.RunState tmpRunState = this.runState;
                if (tmpRunState == CPU.RunState.STATE_RUNNING || tmpRunState == CPU.RunState.STATE_STOPPED_NORMAL) {
                    tmpRunState = CPU.RunState.STATE_STOPPED_BREAK;
                }
                this.runState = tmpRunState;
                this.notifyStateChanged(tmpRunState);
            }
        });
        this.waitForFuture(future);
    }

    @Override
    public void stop() {
        Future<?> future = this.eventReceiver.submit(() -> {
            CPU.RunState tmpRunState = this.runState;
            if (tmpRunState == CPU.RunState.STATE_STOPPED_BREAK || tmpRunState == CPU.RunState.STATE_RUNNING) {
                this.requestStop();
                this.ensureCpuIsStopped();
                tmpRunState = this.runState;
                if (tmpRunState == CPU.RunState.STATE_RUNNING || tmpRunState == CPU.RunState.STATE_STOPPED_BREAK) {
                    tmpRunState = CPU.RunState.STATE_STOPPED_NORMAL;
                }
                this.runState = tmpRunState;
                this.notifyStateChanged(tmpRunState);
            }
        });
        this.waitForFuture(future);
    }

    @Override
    public void step() {
        Future<?> future = this.eventReceiver.submit(() -> {
            if (this.runState == CPU.RunState.STATE_STOPPED_BREAK) {
                CPU.RunState tmpRunState = CPU.RunState.STATE_STOPPED_ADDR_FALLOUT;
                try {
                    tmpRunState = this.stepInternal();
                    if (tmpRunState == CPU.RunState.STATE_RUNNING) {
                        tmpRunState = CPU.RunState.STATE_STOPPED_BREAK;
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    LOGGER.error("Unexpected error during emulation", (Throwable)e);
                }
                catch (Exception e) {
                    if (!(e.getCause() instanceof IndexOutOfBoundsException)) {
                        tmpRunState = CPU.RunState.STATE_STOPPED_BAD_INSTR;
                    }
                    LOGGER.error("Unexpected error during emulation", (Throwable)e);
                }
                finally {
                    this.runState = tmpRunState;
                    this.notifyStateChanged(tmpRunState);
                }
            }
        });
        this.waitForFuture(future);
    }

    private void requestStop() {
        CPUWatchTask tmpCpuWatchTask = this.cpuWatchTask;
        if (tmpCpuWatchTask != null) {
            tmpCpuWatchTask.requestStop();
        }
    }

    protected abstract CPU.RunState stepInternal() throws Exception;

    protected abstract void resetInternal(int var1);

    private class CPUWatchTask
    implements Runnable {
        private final Future<CPU.RunState> cpuFuture;

        private CPUWatchTask(Future<CPU.RunState> cpuFuture) {
            this.cpuFuture = Objects.requireNonNull(cpuFuture);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CPU.RunState originalRunState;
            CPU.RunState tmpRunState = originalRunState = AbstractCPU.this.runState;
            try {
                tmpRunState = this.cpuFuture.get();
            }
            catch (ExecutionException e) {
                Throwable cause;
                tmpRunState = e.getCause() instanceof IndexOutOfBoundsException ? CPU.RunState.STATE_STOPPED_ADDR_FALLOUT : ((cause = e.getCause().getCause()) instanceof IndexOutOfBoundsException ? CPU.RunState.STATE_STOPPED_ADDR_FALLOUT : CPU.RunState.STATE_STOPPED_BAD_INSTR);
                LOGGER.error("Unexpected error during emulation", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                AbstractCPU.this.runState = tmpRunState;
                if (originalRunState != tmpRunState) {
                    AbstractCPU.this.notifyStateChanged(tmpRunState);
                }
            }
        }

        void requestStop() {
            this.cpuFuture.cancel(true);
        }
    }
}

