/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.emulib.plugins.cpu;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.emustudio.emulib.runtime.helpers.Bits;

public class DecodedInstruction {
    private final Map<Integer, Integer> constants = new HashMap<Integer, Integer>();
    private final Map<Integer, String> strings = new HashMap<Integer, String>();
    private final Map<Integer, Bits> bits = new HashMap<Integer, Bits>();
    private byte[] image;

    public void add(int key, String string, int constant) {
        this.constants.put(key, constant);
        this.strings.put(key, string);
    }

    public void add(int key, int bits, int length) {
        this.bits.put(key, new Bits(bits, length));
    }

    public boolean hasKey(int key) {
        return this.bits.containsKey(key) || this.constants.containsKey(key);
    }

    public int get(int key) {
        Integer value = this.constants.get(key);
        return value != null ? value : -1;
    }

    public String getString(int key) {
        return this.strings.get(key);
    }

    public Bits getBits(int key) {
        return this.bits.get(key);
    }

    public byte[] getImage() {
        return this.image;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public int getLength() {
        return this.image.length;
    }

    public Set<Integer> getKeys() {
        HashSet<Integer> keys = new HashSet<Integer>(this.constants.keySet());
        keys.addAll(this.bits.keySet());
        return keys;
    }

    public String toString() {
        return Arrays.toString(this.image);
    }
}

