/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.emulib.plugins.cpu;

import java.util.Queue;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class TimedEventsProcessor {
    private final AtomicInteger cycleMaximum = new AtomicInteger(0);
    private final SortedMap<Integer, Queue<Runnable>> eventQueue = new ConcurrentSkipListMap<Integer, Queue<Runnable>>();
    private int clock;
    private int lastProcessedCycles = 0;

    public void schedule(int cycles, Runnable event) {
        if (cycles <= 0) {
            throw new IllegalArgumentException("Allowed cycles schedule for an event must be > 0");
        }
        this.cycleMaximum.getAndUpdate(i -> Math.max(i, cycles));
        ConcurrentLinkedQueue<Runnable> cyclesEvent = new ConcurrentLinkedQueue<Runnable>();
        cyclesEvent.add(event);
        Queue prevCyclesEvent = this.eventQueue.putIfAbsent(cycles, cyclesEvent);
        if (prevCyclesEvent != null) {
            prevCyclesEvent.add(event);
        }
    }

    public void remove(int cycles, Runnable function) {
        Queue cyclesEvent = (Queue)this.eventQueue.get(cycles);
        cyclesEvent.remove(function);
    }

    public void advanceClock(int cycles) {
        this.clock += cycles;
        this.eventQueue.subMap(this.lastProcessedCycles, this.clock + 1).values().forEach(e -> e.forEach(Runnable::run));
        this.lastProcessedCycles = this.clock + 1;
        int currentCycleMaximum = this.cycleMaximum.get();
        if (this.clock > currentCycleMaximum) {
            this.clock %= currentCycleMaximum + 1;
            this.lastProcessedCycles = 0;
        }
    }
}

