/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.emulib.runtime.helpers;

import java.nio.ByteBuffer;
import net.emustudio.emulib.runtime.helpers.NumberUtils;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class Bits {
    public int bits;
    public final int length;
    private final int mask;

    public Bits(int bits, int length) {
        this.bits = bits;
        this.length = length;
        this.mask = (1 << length) - 1;
    }

    public byte[] toBytes() {
        return ByteBuffer.allocate(4).putInt(this.bits).array();
    }

    public Bits reverseBytes() {
        this.bits = Integer.reverseBytes(this.bits) >>> 32 - this.length;
        return this;
    }

    public Bits reverseBits() {
        this.bits = NumberUtils.reverseBits(this.bits, this.length);
        return this;
    }

    public Bits absolute() {
        this.bits = Math.abs(this.bits);
        return this;
    }

    public Bits shiftLeft() {
        this.bits = this.bits << 1 & this.mask;
        return this;
    }

    public Bits shiftRight() {
        this.bits >>>= 1;
        return this;
    }
}

