/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.emulib.runtime.helpers;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class NumberUtils {
    public static int reverseBits(int value, int numberOfBits) {
        int result = value & (numberOfBits == 32 ? 0 : -1 << numberOfBits);
        for (int i = 0; i < numberOfBits; ++i) {
            result |= (value >>> i & 1) << numberOfBits - i - 1;
        }
        return result;
    }

    public static long reverseBits(long value, int numberOfBits) {
        long result = 0L;
        for (int i = 0; i < numberOfBits; ++i) {
            result |= (value >>> i & 1L) << numberOfBits - i - 1;
        }
        return result;
    }

    public static int readBits(byte[] bytes, int start, int length, int bytesStrategy) {
        int startByte = start / 8;
        int endByte = (start + length - 1) / 8;
        int div = start / 8;
        int realStart = start - 8 * div;
        int value = NumberUtils.readInt(bytes, startByte, endByte - startByte + 1, bytesStrategy);
        int clear = (int)((1L << length) - 1L);
        boolean littleEndian = (bytesStrategy & 2) != 2;
        int shift = littleEndian ? realStart % 8 : (8 - (realStart + length) % 8) % 8;
        return value >>> shift & clear;
    }

    public static int readInt(Byte[] word, int strategy) {
        return NumberUtils.readInt(NumberUtils.numbersToNativeBytes(word), strategy);
    }

    public static int readInt(byte[] word, int strategy) {
        return NumberUtils.readInt(word, 0, Math.min(4, word.length), strategy);
    }

    public static int readInt(byte[] word, int startOffset, int length, int strategy) {
        assert (length >= 0 && length <= 4 && word.length >= startOffset + length && startOffset >= 0);
        byte[] newarray = new byte[4];
        boolean littleEndian = (strategy & 2) != 2;
        System.arraycopy(word, startOffset, newarray, littleEndian ? 0 : 4 - length, length);
        if ((strategy & 4) == 4) {
            for (int i = 0; i < 4; ++i) {
                newarray[i] = (byte)(NumberUtils.reverseBits(newarray[i], 8) & 0xFF);
            }
        }
        ByteBuffer wrapped = ByteBuffer.wrap(newarray);
        if (littleEndian) {
            wrapped.order(ByteOrder.LITTLE_ENDIAN);
        }
        return wrapped.getInt();
    }

    public static int readInt(Integer[] word, int strategy) {
        return NumberUtils.readInt(NumberUtils.numbersToNativeBytes(word), strategy);
    }

    public static int readInt(int[] word, int strategy) {
        return NumberUtils.readInt(NumberUtils.nativeIntsToNativeBytes(word), strategy);
    }

    public static void writeInt(int value, Integer[] output, int strategy) {
        int toSave = value;
        if ((strategy & 4) == 4) {
            toSave = NumberUtils.reverseBits(value, 32);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        if ((strategy & 2) != 2) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        byteBuffer.putInt(toSave);
        System.arraycopy(NumberUtils.nativeBytesToIntegers(byteBuffer.array()), 0, output, 0, 4);
    }

    public static void writeInt(int value, int[] output, int strategy) {
        int toSave = value;
        if ((strategy & 4) == 4) {
            toSave = NumberUtils.reverseBits(value, 32);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        if ((strategy & 2) != 2) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        byteBuffer.putInt(toSave);
        System.arraycopy(NumberUtils.nativeBytesToInts(byteBuffer.array()), 0, output, 0, 4);
    }

    public static void writeInt(int value, Byte[] output, int strategy) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        if ((strategy & 2) != 2) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        byteBuffer.putInt(value);
        if ((strategy & 4) == 4) {
            for (int i = 0; i < 4; ++i) {
                byteBuffer.array()[i] = (byte)(NumberUtils.reverseBits(byteBuffer.array()[i], 8) & 0xFF);
            }
        }
        System.arraycopy(NumberUtils.nativeBytesToBytes(byteBuffer.array()), 0, output, 0, 4);
    }

    public static void writeInt(int value, byte[] output, int strategy) {
        int toSave = value;
        if ((strategy & 4) == 4) {
            toSave = NumberUtils.reverseBits(value, 32);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        if ((strategy & 2) != 2) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        byteBuffer.putInt(toSave);
        System.arraycopy(byteBuffer.array(), 0, output, 0, 4);
    }

    public static void writeInt(int value, Short[] output, int strategy) {
        int toSave = value;
        if ((strategy & 4) == 4) {
            toSave = NumberUtils.reverseBits(value, 32);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        if ((strategy & 2) != 2) {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        byteBuffer.putInt(toSave);
        System.arraycopy(NumberUtils.nativeBytesToShorts(byteBuffer.array()), 0, output, 0, 4);
    }

    public static Byte[] numbersToBytes(Number[] numbers) {
        Byte[] result = new Byte[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            result[i] = numbers[i].byteValue();
        }
        return result;
    }

    public static byte[] numbersToNativeBytes(Number[] numbers) {
        byte[] result = new byte[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            result[i] = numbers[i].byteValue();
        }
        return result;
    }

    public static Byte[] shortsToBytes(Short[] numbers) {
        Byte[] result = new Byte[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            result[i] = numbers[i].byteValue();
        }
        return result;
    }

    public static byte[] shortsToNativeBytes(Short[] numbers) {
        byte[] result = new byte[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            result[i] = numbers[i].byteValue();
        }
        return result;
    }

    public static short[] shortsToNativeShorts(Short[] numbers) {
        short[] result = new short[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            result[i] = numbers[i];
        }
        return result;
    }

    public static byte[] nativeShortsToNativeBytes(short[] numbers) {
        byte[] result = new byte[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            result[i] = (byte)(numbers[i] & 0xFF);
        }
        return result;
    }

    public static byte[] nativeIntsToNativeBytes(int[] numbers) {
        byte[] result = new byte[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            result[i] = (byte)(numbers[i] & 0xFF);
        }
        return result;
    }

    public static Byte[] nativeShortsToBytes(short[] numbers) {
        Byte[] result = new Byte[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            result[i] = (byte)(numbers[i] & 0xFF);
        }
        return result;
    }

    public static Short[] nativeShortsToShorts(short[] numbers) {
        Short[] result = new Short[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            result[i] = numbers[i];
        }
        return result;
    }

    public static Byte[] nativeBytesToBytes(byte[] array) {
        Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static Integer[] nativeBytesToIntegers(byte[] array) {
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] & 0xFF;
        }
        return result;
    }

    public static Short[] nativeBytesToShorts(byte[] array) {
        Short[] result = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (short)(array[i] & 0xFF);
        }
        return result;
    }

    public static int[] nativeBytesToInts(byte[] array) {
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] & 0xFF;
        }
        return result;
    }

    public static int[] listToNativeInts(List<Integer> list) {
        int[] result = new int[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public static int bcd2bin(int bcd) {
        return (bcd >> 4 & 0xF) * 10 + (bcd & 0xF);
    }

    public static int bin2bcd(int bin) {
        return ((bin / 10 & 0xF) << 4) + (bin % 10 & 0xF);
    }

    public static final class Strategy {
        public static final int LITTLE_ENDIAN = 1;
        public static final int BIG_ENDIAN = 2;
        public static final int REVERSE_BITS = 4;
    }
}

