/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.emulib.runtime.helpers;

public class SleepUtils {
    public static final long SLEEP_PRECISION;
    public static final long SPIN_YIELD_PRECISION;

    public static void preciseSleepNanos(long nanoDuration) {
        long end = System.nanoTime() + nanoDuration;
        long timeLeft = nanoDuration;
        do {
            if (timeLeft > SLEEP_PRECISION) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else if (timeLeft > SPIN_YIELD_PRECISION) {
                Thread.yield();
            }
            timeLeft = end - System.nanoTime();
        } while (!Thread.currentThread().isInterrupted() && timeLeft > 0L);
    }

    static {
        int count = 100;
        long time = 0L;
        for (int i = 0; i < count; ++i) {
            long start = System.nanoTime();
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            time += System.nanoTime() - start;
        }
        SLEEP_PRECISION = time / (long)count;
        SPIN_YIELD_PRECISION = SLEEP_PRECISION / 2L;
    }
}

