/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.emulib.runtime.interaction;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.emustudio.emulib.plugins.compiler.FileExtension;
import net.jcip.annotations.Immutable;

@Immutable
public class FileExtensionsFilter {
    private final String description;
    private final List<String> extensions;

    public FileExtensionsFilter(String description, String ... extensions) {
        this.description = Objects.requireNonNull(description);
        this.extensions = List.of(extensions);
    }

    public FileExtensionsFilter(String description, Collection<String> extensions) {
        this.description = Objects.requireNonNull(description);
        this.extensions = List.copyOf(extensions);
    }

    public FileExtensionsFilter(FileExtension extension) {
        this(extension.getDescription(), extension.getExtension());
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }
}

