/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.emulib.runtime.interaction;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.emustudio.emulib.runtime.helpers.Bits;

public interface Formatter {
    public static final Formatter DEFAULT = new Formatter(){};

    default public String format(char format, Bits bits) {
        switch (format) {
            case 'c': {
                String string = new String(bits.toBytes());
                return string.length() != 0 ? string.substring(0, 1) : "?";
            }
            case 'd': {
                return Integer.toString(bits.bits);
            }
            case 'f': {
                switch (bits.length) {
                    case 32: {
                        return Float.toString(ByteBuffer.wrap(bits.toBytes()).order(ByteOrder.LITTLE_ENDIAN).getFloat());
                    }
                    case 64: {
                        return Double.toString(ByteBuffer.wrap(bits.toBytes()).order(ByteOrder.LITTLE_ENDIAN).getDouble());
                    }
                }
                return "NaN";
            }
            case 's': {
                return new String(bits.toBytes()).replace("\u0000", "");
            }
            case 'x': {
                return Integer.toHexString(bits.bits);
            }
            case 'X': {
                return Integer.toHexString(bits.bits).toUpperCase();
            }
            case '%': {
                return "%";
            }
        }
        return Character.toString(format);
    }
}

