/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.emulib.runtime.interaction;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.KeyListener;
import java.awt.font.TextAttribute;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Objects;

public class GuiUtils {
    public static void addKeyListener(Component component, KeyListener listener) {
        component.addKeyListener(listener);
        if (component instanceof Container) {
            Component[] children;
            Container cont = (Container)component;
            for (Component child : children = cont.getComponents()) {
                GuiUtils.addKeyListener(child, listener);
            }
        }
    }

    public static void removeKeyListener(Component component, KeyListener listener) {
        component.removeKeyListener(listener);
        if (component instanceof Container) {
            Component[] children;
            Container cont = (Container)component;
            for (Component child : children = cont.getComponents()) {
                GuiUtils.removeKeyListener(child, listener);
            }
        }
    }

    public static Font loadFontResource(String path, Class<?> resourceClass, int size) {
        Font font;
        block8: {
            HashMap<TextAttribute, Integer> attrs = new HashMap<TextAttribute, Integer>();
            attrs.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
            InputStream fin = resourceClass.getResourceAsStream(path);
            try {
                Font font2 = Font.createFont(0, Objects.requireNonNull(fin)).deriveFont(0, size).deriveFont(attrs);
                GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font2);
                font = font2;
                if (fin == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return new Font("Monospaced", 0, size);
                }
            }
            fin.close();
        }
        return font;
    }
}

