/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.emulib.runtime.interaction.debugger;

import java.util.Objects;
import net.emustudio.emulib.runtime.interaction.debugger.DebuggerColumn;

public class AddressColumn
implements DebuggerColumn<String> {
    private final String addressFormat;

    public AddressColumn() {
        this("%04X");
    }

    public AddressColumn(String addressFormat) {
        this.addressFormat = Objects.requireNonNull(addressFormat);
    }

    @Override
    public Class<String> getClassType() {
        return String.class;
    }

    @Override
    public String getTitle() {
        return "address";
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public void setValue(int location, Object value) {
    }

    @Override
    public String getValue(int location) {
        return String.format(this.addressFormat, location);
    }

    @Override
    public int getDefaultWidth() {
        return -1;
    }
}

