/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.emulib.runtime.interaction.debugger;

import java.util.Objects;
import net.emustudio.emulib.plugins.cpu.CPU;
import net.emustudio.emulib.runtime.interaction.debugger.CannotSetDebuggerValueException;
import net.emustudio.emulib.runtime.interaction.debugger.DebuggerColumn;

public class BreakpointColumn
implements DebuggerColumn<Boolean> {
    private final CPU cpu;

    public BreakpointColumn(CPU cpu) {
        this.cpu = Objects.requireNonNull(cpu);
    }

    @Override
    public Class<Boolean> getClassType() {
        return Boolean.class;
    }

    @Override
    public String getTitle() {
        return "bp";
    }

    @Override
    public boolean isEditable() {
        return this.cpu.isBreakpointSupported();
    }

    @Override
    public Boolean getValue(int location) {
        if (this.cpu.isBreakpointSupported()) {
            try {
                return this.cpu.isBreakpointSet(location);
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public void setValue(int location, Object shouldSetObject) throws CannotSetDebuggerValueException {
        Boolean shouldSet = (Boolean)shouldSetObject;
        if (this.isEditable()) {
            try {
                if (shouldSet.booleanValue()) {
                    this.cpu.setBreakpoint(location);
                } else {
                    this.cpu.unsetBreakpoint(location);
                }
            }
            catch (IndexOutOfBoundsException e) {
                String msg = "Could not " + (shouldSet != false ? "set" : "unset") + " breakpoint to location " + String.format("%04xh", location);
                throw new CannotSetDebuggerValueException(msg, e);
            }
        }
    }

    @Override
    public int getDefaultWidth() {
        return 20;
    }
}

