/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.emulib.runtime.interaction.debugger;

import java.util.Objects;
import net.emustudio.emulib.plugins.cpu.Disassembler;
import net.emustudio.emulib.plugins.cpu.InvalidInstructionException;
import net.emustudio.emulib.runtime.interaction.debugger.DebuggerColumn;

public class OpcodeColumn
implements DebuggerColumn<String> {
    private final Disassembler disassembler;

    public OpcodeColumn(Disassembler disassembler) {
        this.disassembler = Objects.requireNonNull(disassembler);
    }

    @Override
    public Class<String> getClassType() {
        return String.class;
    }

    @Override
    public String getTitle() {
        return "opcode";
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public void setValue(int location, Object value) {
    }

    @Override
    public String getValue(int location) {
        try {
            return this.disassembler.disassemble(location).getOpCode();
        }
        catch (IndexOutOfBoundsException | InvalidInstructionException e) {
            return "";
        }
    }

    @Override
    public int getDefaultWidth() {
        return -1;
    }
}

