/*
 * Decompiled with CFR 0.152.
 */
package net.emustudio.emulib.runtime.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.emustudio.emulib.plugins.memory.MemoryContext;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class IntelHEX {
    private static final int MAX_DATA_BYTES_COUNT_IN_LINE = 15;
    private final Map<Integer, Byte> program = new HashMap<Integer, Byte>();
    private int nextAddress;

    public int add(String hexString) {
        if (hexString.isEmpty()) {
            return this.nextAddress;
        }
        for (int i = 0; i < hexString.length() - 1; i += 2) {
            String tmp = hexString.substring(i, i + 2);
            this.program.put(this.nextAddress++, Byte.parseByte(tmp, 16));
        }
        return this.nextAddress;
    }

    public int add(byte data) {
        this.program.put(this.nextAddress++, data);
        return this.nextAddress;
    }

    public void add(Map<Integer, String> hexCodeMap) {
        int previousAddress = this.nextAddress;
        hexCodeMap.keySet().stream().sorted().forEach(address -> {
            this.nextAddress = address;
            this.add((String)hexCodeMap.get(this.nextAddress));
        });
        this.nextAddress = Math.max(this.nextAddress, previousAddress);
    }

    public Map<Integer, Byte> getCode() {
        return this.program;
    }

    public void setNextAddress(int address) {
        this.nextAddress = address;
    }

    public <T extends Number> void loadIntoMemory(MemoryContext<T> mem, Function<Byte, T> convert) {
        this.program.keySet().stream().sorted().forEach(address -> {
            byte code = this.program.get(address);
            mem.write((int)address, (Number)convert.apply(code));
        });
    }

    public void generate(String outputFileName) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFileName));){
            this.generate(writer);
        }
    }

    public void generate(Writer writer) throws IOException {
        String fileData = this.generateHEX();
        writer.write(fileData);
    }

    public int findProgramLocation() {
        return this.program.keySet().stream().sorted().findFirst().orElse(0);
    }

    public static IntelHEX parse(File file) throws Exception {
        IntelHEX hexFile = new IntelHEX();
        try (FileChannel channel = new FileInputStream(file).getChannel();){
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            while (buffer.hasRemaining()) {
                char input = (char)buffer.get();
                while (buffer.hasRemaining() && (input == ' ' || input == ';')) {
                    if (input == ' ') {
                        input = IntelHEX.ignoreSpaces(buffer);
                    }
                    if (input != ';') continue;
                    IntelHEX.ignoreLine(buffer);
                    input = (char)buffer.get();
                }
                if (!buffer.hasRemaining()) {
                    break;
                }
                if (input != ':') {
                    throw new IOException("Unexpected character: " + input);
                }
                int bytesCount = IntelHEX.readWord(buffer);
                if (bytesCount == 0) {
                    IntelHEX.ignoreLine(buffer);
                    continue;
                }
                int address = IntelHEX.readDword(buffer);
                int dataType = IntelHEX.readWord(buffer);
                if (dataType != 0) {
                    throw new IOException("Unsupported data type: " + dataType);
                }
                hexFile.setNextAddress(address);
                byte[] hex = new byte[2];
                for (int y = 0; y < bytesCount; ++y) {
                    buffer.get(hex);
                    hexFile.add(Byte.parseByte(new String(hex), 16));
                }
                IntelHEX.ignoreLine(buffer);
            }
        }
        return hexFile;
    }

    public static <T extends Number> int loadIntoMemory(File file, MemoryContext<T> memory, Function<Byte, T> convert) throws Exception {
        IntelHEX hexFile = IntelHEX.parse(file);
        hexFile.loadIntoMemory(memory, convert);
        return hexFile.findProgramLocation();
    }

    private String generateHEX() {
        AtomicReference hexLineAddressStr = new AtomicReference();
        AtomicInteger hexLineAddress = new AtomicInteger(0);
        AtomicInteger hexDataBytesCount = new AtomicInteger(0);
        StringBuilder hexDataBytes = new StringBuilder();
        StringBuilder intelHexContent = new StringBuilder();
        this.program.keySet().stream().sorted().forEach(address -> {
            if (hexLineAddressStr.get() == null) {
                hexLineAddress.set((int)address);
                hexLineAddressStr.set(String.format("%04X", address));
            }
            if (hexLineAddress.get() != address.intValue() || hexDataBytesCount.get() > 15) {
                String fullLine = String.format("%02X%s00%s", hexDataBytesCount.get(), hexLineAddressStr.get(), hexDataBytes);
                intelHexContent.append(String.format(":%s%s\n", fullLine, this.checksum(fullLine)));
                hexDataBytesCount.set(0);
                hexDataBytes.setLength(0);
                hexLineAddress.set((int)address);
                hexLineAddressStr.set(String.format("%04X", address));
            }
            hexDataBytes.append(String.format("%02X", this.program.get(address)));
            hexLineAddress.incrementAndGet();
            hexDataBytesCount.incrementAndGet();
        });
        if (hexDataBytes.length() > 0) {
            String fullLine = String.format("%02X%s00%s", hexDataBytesCount.get(), hexLineAddressStr.get(), hexDataBytes);
            intelHexContent.append(String.format(":%s%s\n", fullLine, this.checksum(fullLine)));
        }
        intelHexContent.append(":00000001FF\n");
        return intelHexContent.toString();
    }

    private String checksum(String lin) {
        int sum = 0;
        for (int i = 0; i < lin.length() - 1; i += 2) {
            sum += Integer.parseInt(lin.substring(i, i + 2), 16);
        }
        int chsum = 256 - (sum %= 256);
        return String.format("%1$02X", chsum);
    }

    private static char ignoreSpaces(ByteBuffer buffer) {
        byte c = buffer.get();
        while (buffer.hasRemaining() && c == 32) {
            c = buffer.get();
        }
        return (char)c;
    }

    private static void ignoreLine(ByteBuffer buffer) {
        if (buffer.hasRemaining()) {
            byte c = buffer.get();
            while (buffer.hasRemaining() && c != 10) {
                c = buffer.get();
            }
        }
    }

    private static int readWord(ByteBuffer buffer) {
        return Integer.parseInt(String.format("%c%c", buffer.get(), buffer.get()), 16);
    }

    private static int readDword(ByteBuffer buffer) {
        String hexString = String.format("%c%c%c%c", buffer.get(), buffer.get(), buffer.get(), buffer.get());
        return Integer.parseInt(hexString, 16);
    }
}

