/*
 * Decompiled with CFR 0.152.
 */
package net.endrealm.realmdrive.factory;

import net.endrealm.realmdrive.exceptions.NotAPrimitiveTypeException;
import net.endrealm.realmdrive.inst.SimpleDriveObject;
import net.endrealm.realmdrive.inst.SimpleElementArray;
import net.endrealm.realmdrive.inst.SimplePrimitiveDriveElement;
import net.endrealm.realmdrive.interfaces.DriveElement;
import net.endrealm.realmdrive.interfaces.DriveElementArray;
import net.endrealm.realmdrive.interfaces.DriveObject;
import net.endrealm.realmdrive.interfaces.DriveService;

public class DriveObjectFactory {
    private DriveService driveService;

    public DriveObjectFactory(DriveService driveService) {
        this.driveService = driveService;
    }

    public DriveObject createEmptyObject() {
        return new SimpleDriveObject(this);
    }

    public DriveElement createPrimitive(Object value) throws NotAPrimitiveTypeException {
        return new SimplePrimitiveDriveElement(value);
    }

    public DriveElementArray createEmptyArray() {
        return new SimpleElementArray(this);
    }

    public DriveService getDriveService() {
        return this.driveService;
    }
}

