/*
 * Decompiled with CFR 0.152.
 */
package net.endrealm.realmdrive.inst;

import java.util.HashMap;
import net.endrealm.realmdrive.exceptions.NotAPrimitiveTypeException;
import net.endrealm.realmdrive.interfaces.DriveElement;
import net.endrealm.realmdrive.interfaces.DriveElementArray;
import net.endrealm.realmdrive.interfaces.DriveObject;
import net.endrealm.realmdrive.utils.ReflectionUtils;

public class SimplePrimitiveDriveElement
implements DriveElement {
    private Object value;

    public SimplePrimitiveDriveElement(Object value) throws NotAPrimitiveTypeException {
        if (!ReflectionUtils.getPrimitiveWrapperTypes().contains(value.getClass())) {
            throw new NotAPrimitiveTypeException((Object)(value + " " + value.getClass()));
        }
        this.value = value;
    }

    @Override
    public Boolean getAsBoolean() throws ClassCastException {
        return (Boolean)this.value;
    }

    @Override
    public Short getAsShort() throws ClassCastException {
        return (Short)this.value;
    }

    @Override
    public Integer getAsInt() throws ClassCastException {
        return (Integer)this.value;
    }

    @Override
    public Long getAsLong() throws ClassCastException {
        return (Long)this.value;
    }

    @Override
    public Character getAsChar() throws ClassCastException {
        return (Character)this.value;
    }

    @Override
    public String getAsString() throws ClassCastException {
        return (String)this.value;
    }

    @Override
    public Float getAsFloat() throws ClassCastException {
        return (Float)this.value;
    }

    @Override
    public Double getAsDouble() throws ClassCastException {
        return (Double)this.value;
    }

    @Override
    public DriveObject getAsObject() throws ClassCastException {
        throw new ClassCastException("This is a primitive drive element, not a drive object");
    }

    @Override
    public DriveElement getAsElement() throws ClassCastException {
        return this;
    }

    @Override
    public DriveElementArray getAsElementArray() throws ClassCastException {
        throw new ClassCastException("This is an drive primitive element not an array");
    }

    @Override
    public Object getPrimitiveValue() {
        return this.value;
    }

    @Override
    public HashMap<String, DriveElement> getSubComponents() {
        return null;
    }

    @Override
    public DriveElement subtract(DriveElement driveElement) {
        if (!(driveElement instanceof SimplePrimitiveDriveElement)) {
            return this.deepClone();
        }
        if (((SimplePrimitiveDriveElement)driveElement).value != this.value) {
            return this.deepClone();
        }
        return null;
    }

    @Override
    public DriveElement add(DriveElement driveElement) {
        return driveElement;
    }

    @Override
    public DriveElement deepClone() {
        return new SimplePrimitiveDriveElement(this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimplePrimitiveDriveElement)) {
            return false;
        }
        SimplePrimitiveDriveElement other = (SimplePrimitiveDriveElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimplePrimitiveDriveElement;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "SimplePrimitiveDriveElement(value=" + this.getValue() + ")";
    }
}

