/*
 * Decompiled with CFR 0.152.
 */
package net.endrealm.realmdrive.inst.serializers;

import java.util.UUID;
import net.endrealm.realmdrive.exceptions.NotAPrimitiveTypeException;
import net.endrealm.realmdrive.inst.SimplePrimitiveDriveElement;
import net.endrealm.realmdrive.interfaces.CustomSerializer;
import net.endrealm.realmdrive.interfaces.DriveElement;

public class UUIDSerializer
implements CustomSerializer<UUID> {
    @Override
    public DriveElement toDriveEndpoint(UUID element) {
        try {
            return new SimplePrimitiveDriveElement(element.toString());
        }
        catch (NotAPrimitiveTypeException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public UUID fromEndpoint(DriveElement endpoint, Class<UUID> uuidClass) {
        try {
            return UUID.fromString(endpoint.getAsString());
        }
        catch (NotAPrimitiveTypeException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean supportsClass(Class clazz) {
        return UUID.class.equals((Object)clazz);
    }
}

