/*
 * Decompiled with CFR 0.152.
 */
package net.endrealm.realmdrive.query;

import java.util.ArrayList;
import java.util.stream.Collectors;
import net.endrealm.realmdrive.query.ExpressionStack;
import net.endrealm.realmdrive.query.QueryComponent;
import net.endrealm.realmdrive.query.compare.EqualsOperator;
import net.endrealm.realmdrive.query.compare.GreaterThanEqualsOperator;
import net.endrealm.realmdrive.query.compare.GreaterThanOperator;
import net.endrealm.realmdrive.query.compare.LessThanEqualsOperator;
import net.endrealm.realmdrive.query.compare.LessThanOperator;
import net.endrealm.realmdrive.query.compare.NotEqualOperator;
import net.endrealm.realmdrive.query.compare.ValueBetweenOperator;
import net.endrealm.realmdrive.query.compare.ValueInOperator;
import net.endrealm.realmdrive.query.compare.ValueNotInOperator;
import net.endrealm.realmdrive.query.logics.AndOperator;
import net.endrealm.realmdrive.query.logics.NorOperator;
import net.endrealm.realmdrive.query.logics.NotOperator;
import net.endrealm.realmdrive.query.logics.OrOperator;

public class Query
implements QueryComponent,
ExpressionStack {
    private ArrayList<QueryComponent> components = new ArrayList();
    private String tableName;
    private String databaseName;

    public Query build() {
        return this;
    }

    @Override
    public AndOperator<Query> addAnd() {
        AndOperator<Query> operator = new AndOperator<Query>(this);
        this.components.add(operator);
        return operator;
    }

    @Override
    public OrOperator<Query> addOr() {
        OrOperator<Query> operator = new OrOperator<Query>(this);
        this.components.add(operator);
        return operator;
    }

    @Override
    public NotOperator<Query> addNot() {
        NotOperator<Query> operator = new NotOperator<Query>(this);
        this.components.add(operator);
        return operator;
    }

    @Override
    public NorOperator<Query> addNor() {
        NorOperator<Query> operator = new NorOperator<Query>(this);
        this.components.add(operator);
        return operator;
    }

    @Override
    public EqualsOperator<Query> addEq() {
        EqualsOperator<Query> operator = new EqualsOperator<Query>(this);
        this.components.add(operator);
        return operator;
    }

    @Override
    public NotEqualOperator<Query> addNe() {
        NotEqualOperator<Query> operator = new NotEqualOperator<Query>(this);
        this.components.add(operator);
        return operator;
    }

    @Override
    public GreaterThanOperator<Query> addGt() {
        GreaterThanOperator<Query> operator = new GreaterThanOperator<Query>(this);
        this.components.add(operator);
        return operator;
    }

    @Override
    public GreaterThanEqualsOperator<Query> addGte() {
        GreaterThanEqualsOperator<Query> operator = new GreaterThanEqualsOperator<Query>(this);
        this.components.add(operator);
        return operator;
    }

    @Override
    public LessThanEqualsOperator<Query> addLte() {
        LessThanEqualsOperator<Query> operator = new LessThanEqualsOperator<Query>(this);
        this.components.add(operator);
        return operator;
    }

    @Override
    public LessThanOperator<Query> addLt() {
        LessThanOperator<Query> operator = new LessThanOperator<Query>(this);
        this.components.add(operator);
        return operator;
    }

    @Override
    public ValueInOperator<Query> addIn() {
        ValueInOperator<Query> operator = new ValueInOperator<Query>(this);
        this.components.add(operator);
        return operator;
    }

    @Override
    public ValueNotInOperator<Query> addNin() {
        ValueNotInOperator<Query> operator = new ValueNotInOperator<Query>(this);
        this.components.add(operator);
        return operator;
    }

    @Override
    public ValueBetweenOperator<Query> addBet() {
        ValueBetweenOperator<Query> operator = new ValueBetweenOperator<Query>(this);
        this.components.add(operator);
        return operator;
    }

    @Override
    public String toJson() {
        return "{" + this.components.stream().map(it -> {
            String json = it.toJson();
            json = json.substring(1);
            json = json.substring(0, json.length() - 1);
            return json;
        }).collect(Collectors.joining(",")) + "}";
    }

    public Query setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    @Deprecated
    public Query setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }
}

