/*
 * Decompiled with CFR 0.152.
 */
package net.endrealm.realmdrive.utils.paging;

import java.util.ArrayList;
import java.util.List;
import net.endrealm.realmdrive.utils.paging.Sorter;
import net.endrealm.realmdrive.utils.paging.SortingOrder;

public final class Pageable {
    private final int page;
    private final int perPage;
    private final List<Sorter> sorters;

    public static PageableBuilder builder(int page, int pageSize) {
        if (page < 0) {
            page = 0;
        }
        if (pageSize < 1) {
            pageSize = 1;
        }
        return new PageableBuilder(page, pageSize, new ArrayList());
    }

    public int getPage() {
        return this.page;
    }

    public int getPerPage() {
        return this.perPage;
    }

    public List<Sorter> getSorters() {
        return this.sorters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pageable)) {
            return false;
        }
        Pageable other = (Pageable)o;
        if (this.getPage() != other.getPage()) {
            return false;
        }
        if (this.getPerPage() != other.getPerPage()) {
            return false;
        }
        List<Sorter> this$sorters = this.getSorters();
        List<Sorter> other$sorters = other.getSorters();
        return !(this$sorters == null ? other$sorters != null : !((Object)this$sorters).equals(other$sorters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPage();
        result = result * 59 + this.getPerPage();
        List<Sorter> $sorters = this.getSorters();
        result = result * 59 + ($sorters == null ? 43 : ((Object)$sorters).hashCode());
        return result;
    }

    public String toString() {
        return "Pageable(page=" + this.getPage() + ", perPage=" + this.getPerPage() + ", sorters=" + this.getSorters() + ")";
    }

    private Pageable(int page, int perPage, List<Sorter> sorters) {
        this.page = page;
        this.perPage = perPage;
        this.sorters = sorters;
    }

    public static class PageableBuilder {
        private int page;
        private int perPage;
        private final List<Sorter> sorters;

        public void addSorting(String key, SortingOrder order) {
            this.sorters.add(new Sorter(key, order));
        }

        public void setPage(int page) {
            if (page < 0) {
                return;
            }
            this.page = page;
        }

        public void setPerPage(int perPage) {
            if (perPage < 1) {
                return;
            }
            this.perPage = perPage;
        }

        public Pageable build() {
            return new Pageable(this.page, this.perPage, this.sorters);
        }

        private PageableBuilder(int page, int perPage, List<Sorter> sorters) {
            this.page = page;
            this.perPage = perPage;
            this.sorters = sorters;
        }
    }
}

