/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy;

import java.util.Collection;
import net.engio.mbassy.subscription.Subscription;

public class MessagePublication<T> {
    private Collection<Subscription> subscriptions;
    private T message;
    private State state = State.Scheduled;

    public static <T> MessagePublication<T> Create(Collection<Subscription> subscriptions, T message) {
        return new MessagePublication<T>(subscriptions, message, State.Initial);
    }

    private MessagePublication(Collection<Subscription> subscriptions, T message, State initialState) {
        this.subscriptions = subscriptions;
        this.message = message;
        this.state = initialState;
    }

    public boolean add(Subscription subscription) {
        return this.subscriptions.add(subscription);
    }

    protected void execute() {
        this.state = State.Running;
        for (Subscription sub : this.subscriptions) {
            sub.publish(this.message);
        }
        this.state = State.Finished;
    }

    public boolean isFinished() {
        return this.state.equals((Object)State.Finished);
    }

    public boolean isRunning() {
        return this.state.equals((Object)State.Running);
    }

    public boolean isScheduled() {
        return this.state.equals((Object)State.Scheduled);
    }

    public MessagePublication<T> markScheduled() {
        if (!this.state.equals((Object)State.Initial)) {
            return this;
        }
        this.state = State.Scheduled;
        return this;
    }

    public MessagePublication<T> setError() {
        this.state = State.Error;
        return this;
    }

    private static enum State {
        Initial,
        Scheduled,
        Running,
        Finished,
        Error;

    }
}

