/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import net.engio.mbassy.AbstractMessageBus;
import net.engio.mbassy.BusConfiguration;
import net.engio.mbassy.MessagePublication;
import net.engio.mbassy.PublicationError;
import net.engio.mbassy.SyncAsyncPostCommand;
import net.engio.mbassy.common.DeadEvent;
import net.engio.mbassy.subscription.Subscription;

public class MBassador<T>
extends AbstractMessageBus<T, SyncAsyncPostCommand<T>> {
    public MBassador(BusConfiguration configuration) {
        super(configuration);
    }

    public MessagePublication publishAsync(T message) {
        return this.addAsynchronousDeliveryRequest(this.createMessagePublication(message));
    }

    public MessagePublication publishAsync(T message, long timeout, TimeUnit unit) {
        return this.addAsynchronousDeliveryRequest(this.createMessagePublication(message), timeout, unit);
    }

    private MessagePublication createMessagePublication(T message) {
        Collection<Subscription> subscriptions = this.getSubscriptionsByMessageType(message.getClass());
        if (subscriptions == null || subscriptions.isEmpty()) {
            subscriptions = this.getSubscriptionsByMessageType(DeadEvent.class);
            return MessagePublication.Create(subscriptions, new DeadEvent(message));
        }
        return MessagePublication.Create(subscriptions, message);
    }

    public void publish(T message) {
        try {
            MessagePublication publication = this.createMessagePublication(message);
            publication.execute();
        }
        catch (Throwable e) {
            this.handlePublicationError(new PublicationError().setMessage("Error during publication of message").setCause(e).setPublishedObject(message));
        }
    }

    @Override
    public SyncAsyncPostCommand<T> post(T message) {
        return new SyncAsyncPostCommand<T>(this, message);
    }
}

