/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy;

import java.util.Collection;
import net.engio.mbassy.common.DeadEvent;
import net.engio.mbassy.subscription.Subscription;

public class MessagePublication {
    private Collection<Subscription> subscriptions;
    private Object message;
    private State state = State.Scheduled;

    public static MessagePublication Create(Collection<Subscription> subscriptions, Object message) {
        return new MessagePublication(subscriptions, message, State.Initial);
    }

    private MessagePublication(Collection<Subscription> subscriptions, Object message, State initialState) {
        this.subscriptions = subscriptions;
        this.message = message;
        this.state = initialState;
    }

    public boolean add(Subscription subscription) {
        return this.subscriptions.add(subscription);
    }

    protected void execute() {
        this.state = State.Running;
        for (Subscription sub : this.subscriptions) {
            sub.publish(this.message);
        }
        this.state = State.Finished;
    }

    public boolean isFinished() {
        return this.state.equals((Object)State.Finished);
    }

    public boolean isRunning() {
        return this.state.equals((Object)State.Running);
    }

    public boolean isScheduled() {
        return this.state.equals((Object)State.Scheduled);
    }

    public MessagePublication markScheduled() {
        if (!this.state.equals((Object)State.Initial)) {
            return this;
        }
        this.state = State.Scheduled;
        return this;
    }

    public MessagePublication setError() {
        this.state = State.Error;
        return this;
    }

    public boolean isDeadEvent() {
        return DeadEvent.class.isAssignableFrom(this.message.getClass());
    }

    private static enum State {
        Initial,
        Scheduled,
        Running,
        Finished,
        Error;

    }
}

