/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.listener;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import net.engio.mbassy.listener.Enveloped;
import net.engio.mbassy.listener.Handler;
import net.engio.mbassy.listener.IMessageFilter;
import net.engio.mbassy.listener.Mode;

public class MessageHandlerMetadata {
    private Method handler;
    private IMessageFilter[] filter;
    private Handler handlerConfig;
    private boolean isAsynchronous = false;
    private Enveloped envelope = null;
    private List<Class<?>> handledMessages = new LinkedList();
    private boolean acceptsSubtypes = true;

    public MessageHandlerMetadata(Method handler, IMessageFilter[] filter, Handler handlerConfig) {
        this.handler = handler;
        this.filter = filter;
        this.handlerConfig = handlerConfig;
        this.isAsynchronous = handlerConfig.delivery().equals((Object)Mode.Concurrent);
        this.envelope = handler.getAnnotation(Enveloped.class);
        boolean bl = this.acceptsSubtypes = !handlerConfig.rejectSubtypes();
        if (this.envelope != null) {
            for (Class messageType : this.envelope.messages()) {
                this.handledMessages.add(messageType);
            }
        } else {
            this.handledMessages.add(handler.getParameterTypes()[0]);
        }
        this.handler.setAccessible(true);
    }

    public boolean isAsynchronous() {
        return this.isAsynchronous;
    }

    public boolean isFiltered() {
        return this.filter != null && this.filter.length > 0;
    }

    public int getPriority() {
        return this.handlerConfig.priority();
    }

    public Method getHandler() {
        return this.handler;
    }

    public IMessageFilter[] getFilter() {
        return this.filter;
    }

    public List<Class<?>> getHandledMessages() {
        return this.handledMessages;
    }

    public boolean isEnveloped() {
        return this.envelope != null;
    }

    public boolean handlesMessage(Class<?> messageType) {
        for (Class<?> handledMessage : this.handledMessages) {
            if (handledMessage.equals(messageType)) {
                return true;
            }
            if (!handledMessage.isAssignableFrom(messageType) || !this.acceptsSubtypes()) continue;
            return true;
        }
        return false;
    }

    public boolean acceptsSubtypes() {
        return this.acceptsSubtypes;
    }

    public boolean isEnabled() {
        return this.handlerConfig.enabled();
    }
}

