/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.listener;

import java.util.LinkedList;
import java.util.List;
import net.engio.mbassy.common.IPredicate;
import net.engio.mbassy.listener.MessageHandlerMetadata;

public class MessageListenerMetadata<T> {
    private List<MessageHandlerMetadata> handlers;
    private Class<T> listenerDefinition;

    public static IPredicate<MessageHandlerMetadata> ForMessage(final Class<?> messageType) {
        return new IPredicate<MessageHandlerMetadata>(){

            @Override
            public boolean apply(MessageHandlerMetadata target) {
                return target.handlesMessage(messageType);
            }
        };
    }

    public MessageListenerMetadata(List<MessageHandlerMetadata> handlers, Class<T> listenerDefinition) {
        this.handlers = handlers;
        this.listenerDefinition = listenerDefinition;
    }

    public List<MessageHandlerMetadata> getHandlers(IPredicate<MessageHandlerMetadata> filter) {
        LinkedList<MessageHandlerMetadata> matching = new LinkedList<MessageHandlerMetadata>();
        for (MessageHandlerMetadata handler : this.handlers) {
            if (!filter.apply(handler)) continue;
            matching.add(handler);
        }
        return matching;
    }

    public boolean handles(Class<?> messageType) {
        return !this.getHandlers(MessageListenerMetadata.ForMessage(messageType)).isEmpty();
    }

    public Class<T> getListerDefinition() {
        return this.listenerDefinition;
    }
}

