/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.bus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.engio.mbassy.bus.BusRuntime;
import net.engio.mbassy.bus.IMessagePublication;
import net.engio.mbassy.bus.MessagePublication;
import net.engio.mbassy.bus.common.DeadMessage;
import net.engio.mbassy.bus.common.PubSubSupport;
import net.engio.mbassy.bus.config.Feature;
import net.engio.mbassy.bus.config.IBusConfiguration;
import net.engio.mbassy.bus.error.IPublicationErrorHandler;
import net.engio.mbassy.bus.error.PublicationError;
import net.engio.mbassy.subscription.Subscription;
import net.engio.mbassy.subscription.SubscriptionManager;

public abstract class AbstractPubSubSupport<T>
implements PubSubSupport<T> {
    private final List<IPublicationErrorHandler> errorHandlers = new ArrayList<IPublicationErrorHandler>();
    private final MessagePublication.Factory publicationFactory;
    private final SubscriptionManager subscriptionManager;
    private final BusRuntime runtime;

    public AbstractPubSubSupport(IBusConfiguration configuration) {
        if (!configuration.hasProperty("bus.handlers.error")) {
            System.out.println("WARN: No error handler configured to handle exceptions during publication.\nError handlers can be added to any instance of  AbstractPubSubSupport or via BusConfiguration. \nFalling back to console logger.");
        }
        this.errorHandlers.add(configuration.getProperty("bus.handlers.error", new IPublicationErrorHandler.ConsoleLogger()));
        this.runtime = new BusRuntime(this).add("bus.handlers.error", this.getRegisteredErrorHandlers()).add("bus.id", UUID.randomUUID().toString());
        Feature.SyncPubSub pubSubFeature = configuration.getFeature(Feature.SyncPubSub.class);
        this.subscriptionManager = pubSubFeature.getSubscriptionManagerProvider().createManager(pubSubFeature.getMetadataReader(), pubSubFeature.getSubscriptionFactory(), this.runtime);
        this.publicationFactory = pubSubFeature.getPublicationFactory();
    }

    protected MessagePublication.Factory getPublicationFactory() {
        return this.publicationFactory;
    }

    public Collection<IPublicationErrorHandler> getRegisteredErrorHandlers() {
        return Collections.unmodifiableCollection(this.errorHandlers);
    }

    @Override
    public boolean unsubscribe(Object listener) {
        return this.subscriptionManager.unsubscribe(listener);
    }

    @Override
    public void subscribe(Object listener) {
        this.subscriptionManager.subscribe(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addErrorHandler(IPublicationErrorHandler handler) {
        AbstractPubSubSupport abstractPubSubSupport = this;
        synchronized (abstractPubSubSupport) {
            this.errorHandlers.add(handler);
        }
    }

    @Override
    public BusRuntime getRuntime() {
        return this.runtime;
    }

    protected IMessagePublication createMessagePublication(T message) {
        Collection<Subscription> subscriptions = this.getSubscriptionsByMessageType(message.getClass());
        if ((subscriptions == null || subscriptions.isEmpty()) && !message.getClass().equals(DeadMessage.class)) {
            subscriptions = this.getSubscriptionsByMessageType(DeadMessage.class);
            return this.getPublicationFactory().createPublication(this.runtime, subscriptions, new DeadMessage(message));
        }
        return this.getPublicationFactory().createPublication(this.runtime, subscriptions, message);
    }

    protected Collection<Subscription> getSubscriptionsByMessageType(Class messageType) {
        return this.subscriptionManager.getSubscriptionsByMessageType(messageType);
    }

    public void handlePublicationError(PublicationError error) {
        for (IPublicationErrorHandler errorHandler : this.errorHandlers) {
            errorHandler.handleError(error);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ " + this.runtime.get("bus.id") + "}";
    }
}

